/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities.ai;

import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.entities.ai.ShieldCombatGoal;
import blusunrize.immersiveengineering.common.entities.illager.Bulwark;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.util.IESounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChemthrowerAttackGoal<T extends Bulwark>
extends ShieldCombatGoal<T> {
    private int counter = -1;
    private final FluidStack fluidStack = new FluidStack((Fluid)IEFluids.ETHANOL.getStill(), 1000);

    public ChemthrowerAttackGoal(T mob, float attackRadius) {
        super(mob, attackRadius, new ShieldCombatGoal.IntRange(120, 180), new ShieldCombatGoal.IntRange(0, 1));
    }

    @Override
    protected boolean isHoldingWeapon() {
        return ((Bulwark)this.mob).isHolding(is -> is.getItem() instanceof ChemthrowerItem);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.combatState == ShieldCombatGoal.ShieldCombatState.ATTACK && !((Bulwark)this.mob).isAiming()) {
            ((Bulwark)this.mob).setAiming(true);
        }
        if (this.combatState != ShieldCombatGoal.ShieldCombatState.ATTACK && ((Bulwark)this.mob).isAiming()) {
            ((Bulwark)this.mob).setAiming(false);
        }
    }

    @Override
    boolean performAttack() {
        ++this.counter;
        Vec3 v = ((Bulwark)this.mob).getLookAngle();
        int split = 8;
        boolean isGas = this.fluidStack.getFluid().is(Tags.Fluids.GASEOUS);
        float scatter = isGas ? 0.25f : 0.15f;
        float range = isGas ? 0.5f : 1.0f;
        RandomSource random = ((Bulwark)this.mob).getRandom();
        for (int i = 0; i < split; ++i) {
            Vec3 vecDir = v.add(random.nextGaussian() * (double)scatter, random.nextGaussian() * (double)scatter, random.nextGaussian() * (double)scatter);
            ChemthrowerShotEntity chem = new ChemthrowerShotEntity(((Bulwark)this.mob).level(), (LivingEntity)this.mob, vecDir.x * 0.25, vecDir.y * 0.25, vecDir.z * 0.25, this.fluidStack);
            chem.setDeltaMovement(((Bulwark)this.mob).getDeltaMovement().add(vecDir.scale((double)range)));
            chem.igniteForSeconds(10.0f);
            if (((Bulwark)this.mob).level().isClientSide) continue;
            ((Bulwark)this.mob).level().addFreshEntity((Entity)chem);
        }
        if (this.counter % 4 == 0) {
            ((Bulwark)this.mob).level().playSound(null, ((Bulwark)this.mob).getX(), ((Bulwark)this.mob).getY(), ((Bulwark)this.mob).getZ(), (SoundEvent)IESounds.sprayFire.value(), SoundSource.PLAYERS, 0.5f, 1.5f);
        }
        if (this.counter >= 40) {
            this.counter = 0;
            return true;
        }
        return false;
    }
}

