/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class RevolverCycleRecipe
extends CustomRecipe {
    public RevolverCycleRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, @Nonnull Level world) {
        ItemStack revolver = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (revolver.isEmpty() && stackInSlot.getItem() == IEItems.Weapons.REVOLVER.asItem()) {
                revolver = stackInSlot;
                continue;
            }
            return false;
        }
        return !revolver.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        ItemStack revolver = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (revolver.isEmpty() && stackInSlot.getItem() == IEItems.Weapons.REVOLVER.asItem()) {
                revolver = stackInSlot.copy();
                continue;
            }
            return ItemStack.EMPTY;
        }
        return revolver;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider access) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.REVOLVER_CYCLE_SERIALIZER.get();
    }
}

