/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.AutoWorkbenchShapes;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class AutoWorkbenchLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int BLUEPRINT_SLOT = 0;
    public static final int FIRST_INPUT_SLOT = 1;
    public static final int NUM_INPUT_SLOTS = 16;
    public static final int NUM_SLOTS = 17;
    public static final int ENERGY_CAPACITY = 32000;
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 1, 1, RelativeBlockFace.RIGHT);
    private static final BlockPos INPUT_POS = new BlockPos(0, 1, 2);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_POS = new BlockPos(1, 0, 2);
    public static final BlockPos PROCESS_1_POS = new BlockPos(1, 0, 0);
    public static final BlockPos PROCESS_2_POS = new BlockPos(2, 1, 1);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean isRSEnabled = state.rsState.isEnabled(context);
        boolean active = state.processor.tickServer(state, context.getLevel(), isRSEnabled);
        if (active != state.active) {
            state.active = active;
            context.requestMasterBESync();
        }
        if (!context.getLevel().shouldTickModulo(16)) {
            return;
        }
        if (!isRSEnabled || state.inventory.getStackInSlot(0).isEmpty()) {
            return;
        }
        List<RecipeHolder<BlueprintCraftingRecipe>> recipes = AutoWorkbenchLogic.getAvailableRecipes(context.getLevel().getRawLevel(), state);
        if (state.selectedRecipe >= 0 && state.selectedRecipe < recipes.size()) {
            RecipeHolder<BlueprintCraftingRecipe> holder = recipes.get(state.selectedRecipe);
            BlueprintCraftingRecipe recipe = (BlueprintCraftingRecipe)holder.value();
            if (!recipe.output.get().isEmpty()) {
                NonNullList query = NonNullList.withSize((int)16, (Object)ItemStack.EMPTY);
                for (int i = 0; i < query.size(); ++i) {
                    query.set(i, (Object)state.inventory.getStackInSlot(i + 1));
                }
                int crafted = recipe.getMaxCrafted((NonNullList<ItemStack>)query);
                if (crafted > 0 && state.processor.addProcessToQueue(new MultiblockProcessInWorld<BlueprintCraftingRecipe>(holder, 0.78f, (NonNullList<ItemStack>)NonNullList.create()), context.getLevel().getRawLevel(), true)) {
                    state.processor.addProcessToQueue(new MultiblockProcessInWorld<BlueprintCraftingRecipe>(holder, 0.78f, recipe.consumeInputs((NonNullList<ItemStack>)query, 1)), context.getLevel().getRawLevel(), false);
                    for (int i = 0; i < query.size(); ++i) {
                        state.inventory.setStackInSlot(i + 1, (ItemStack)query.get(i));
                    }
                }
            }
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        if (context.getState().active) {
            block6: for (MultiblockProcess process : context.getState().processor.getQueue()) {
                ++process.processTick;
                Player localPlayer = ImmersiveEngineering.proxy.getClientPlayer();
                switch (process.processTick) {
                    default: {
                        continue block6;
                    }
                    case 39: {
                        rawLevel.playSound(localPlayer, level.toAbsolute(PROCESS_1_POS), (SoundEvent)IESounds.process1.value(), SoundSource.BLOCKS, 0.25f, 1.0f);
                        continue block6;
                    }
                    case 40: 
                    case 78: {
                        rawLevel.playSound(localPlayer, level.toAbsolute(PROCESS_1_POS), (SoundEvent)IESounds.process1Lift.value(), SoundSource.BLOCKS, 0.64f, 1.0f);
                        continue block6;
                    }
                    case 136: 
                    case 163: {
                        rawLevel.playSound(localPlayer, level.toAbsolute(PROCESS_2_POS), (SoundEvent)IESounds.process2Lift.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        continue block6;
                    }
                    case 144: 
                }
                rawLevel.playSound(localPlayer, level.toAbsolute(PROCESS_2_POS), (SoundEvent)IESounds.process2.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public static List<RecipeHolder<BlueprintCraftingRecipe>> getAvailableRecipes(Level level, State state) {
        return EngineersBlueprintItem.getRecipes(level, state.inventory.getStackInSlot(0));
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.ItemHandler.BLOCK, (state, pos) -> INPUT_POS.equals((Object)pos.posInMultiblock()) ? state.input : null);
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_POS, state -> state.energy);
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems(state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return AutoWorkbenchShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(ComparatorManager.SimpleComparatorValue.inventory(ProcessContext::getInventory, 1, 16), REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<BlueprintCraftingRecipe> {
        public final SlotwiseItemHandler inventory;
        public int selectedRecipe = -1;
        public final MultiblockProcessor.InWorldProcessor<BlueprintCraftingRecipe> processor;
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public boolean active;
        private final DroppingMultiblockOutput output;
        private final IItemHandler input;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;

        public State(IInitialMultiblockContext<State> ctx) {
            this.processor = new MultiblockProcessor.InWorldProcessor<BlueprintCraftingRecipe>(3, $ -> 0.4375, 3, ctx.getMarkDirtyRunnable(), ctx.getSyncRunnable(), BlueprintCraftingRecipe.RECIPES::getById);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(new SlotwiseItemHandler.IOConstraint(true, i -> i.is(IEItems.Misc.BLUEPRINT.asItem())), 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 17)), ctx.getMarkDirtyRunnable());
            this.input = new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(1, 17));
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.input, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation<AveragingEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.putInt("selectedRecipe", this.selectedRecipe);
            nbt.put("processor", this.processor.toNBT(provider));
            nbt.put("energy", this.energy.serializeNBT(provider));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.selectedRecipe = nbt.getInt("selectedRecipe");
            this.processor.fromNBT(nbt.get("processor"), MultiblockProcessInWorld::new, provider);
            this.energy.deserializeNBT(provider, nbt.get("energy"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("processor", this.processor.toNBT(provider));
            nbt.putBoolean("active", this.active);
            nbt.put("blueprint", this.inventory.getStackInSlot(0).saveOptional(provider));
            nbt.putInt("selectedRecipe", this.selectedRecipe);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.processor.fromNBT(nbt.get("processor"), MultiblockProcessInWorld::new, provider);
            this.active = nbt.getBoolean("active");
            this.inventory.setStackInSlot(0, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("blueprint")));
            this.selectedRecipe = nbt.getInt("selectedRecipe");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }
    }
}

