/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.mixin.accessors.client.ParticleManagerAccess;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

public class ClocheBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE<ClocheBlockEntity>,
IModelOffsetProvider {
    public static final int SLOT_SOIL = 0;
    public static final int SLOT_SEED = 1;
    public static final int SLOT_FERTILIZER = 2;
    public static final int NUM_SLOTS = 7;
    public static final int TANK_CAPACITY = 4000;
    public static final int ENERGY_CAPACITY = 16000;
    public int dummy = 0;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
    public final FluidTank tank = new FluidTank(4000){

        public boolean isFluidValid(FluidStack fluid) {
            return ClocheRecipe.getValidFluids(ClocheBlockEntity.this.getLevel()).anyMatch(req -> req.test(fluid));
        }
    };
    public MutableEnergyStorage energyStorage;
    public final Supplier<ClocheRecipe> cachedRecipe;
    public int fertilizerAmount;
    public float fertilizerMod;
    private float growth;
    public float renderGrowth;
    public boolean renderActive;
    private final IEBlockCapabilityCaches.IEBlockCapabilityCache<IItemHandler> output;
    private final MultiblockCapability<IItemHandler> inputHandler;
    private final MultiblockCapability<IItemHandler> outputHandler;
    private final MultiblockCapability<IFluidHandler> tankCap;
    private final MultiblockCapability<IEnergyStorage> energyCap;
    public AABB renderBB;

    public ClocheBlockEntity(BlockEntityType<ClocheBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyStorage = new MutableEnergyStorage(16000, Math.max(256, IEServerConfig.getOrDefault(IEServerConfig.MACHINES.cloche_consumption)));
        this.cachedRecipe = CachedRecipe.cached(ClocheRecipe::findRecipe, () -> this.level, () -> (ItemStack)this.inventory.get(1), () -> (ItemStack)this.inventory.get(0), () -> ((FluidTank)this.tank).getFluid());
        this.fertilizerAmount = 0;
        this.fertilizerMod = 1.0f;
        this.growth = 0.0f;
        this.renderGrowth = 0.0f;
        this.renderActive = false;
        this.output = IEBlockCapabilityCaches.create(Capabilities.ItemHandler.BLOCK, () -> this.worldPosition.above().relative(this.getFacing().getOpposite()), this::getFacing, () -> ((ClocheBlockEntity)this).getLevel());
        this.inputHandler = MultiblockCapability.make(this, be -> be.inputHandler, ClocheBlockEntity::master, new IEInventoryHandler(1, (IIEInventory)this, 2, true, false));
        this.outputHandler = MultiblockCapability.make(this, be -> be.outputHandler, ClocheBlockEntity::master, new IEInventoryHandler(4, (IIEInventory)this, 3, false, true));
        this.tankCap = MultiblockCapability.make(this, be -> be.tankCap, ClocheBlockEntity::master, this.tank);
        this.energyCap = MultiblockCapability.make(this, be -> be.energyCap, ClocheBlockEntity::master, this.energyStorage);
    }

    @Override
    public boolean canTickAny() {
        return !this.isRSPowered();
    }

    @Override
    public void tickClient() {
        ClocheRecipe recipe;
        ItemStack seed = (ItemStack)this.inventory.get(1);
        ItemStack soil = (ItemStack)this.inventory.get(0);
        if (this.renderActive && (recipe = this.cachedRecipe.get()) != null && this.fertilizerAmount > 0) {
            double addGrow = (Double)IEServerConfig.MACHINES.cloche_growth_mod.get() * (double)this.fertilizerMod;
            this.renderGrowth = (double)this.renderGrowth < (double)recipe.getTime(seed, soil) + addGrow ? (float)((double)this.renderGrowth + addGrow) : 0.0f;
            if (ApiUtils.RANDOM.nextInt(8) == 0) {
                Particle p = ((ParticleManagerAccess)Minecraft.getInstance().particleEngine).invokeMakeParticle(new DustParticleOptions(new Vector3f(0.55f, 0.1f, 0.1f), 1.0f), (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 2.6875, (double)this.getBlockPos().getZ() + 0.5, 0.25, 0.25, 0.25);
                p.setLifetime(20);
                Minecraft.getInstance().particleEngine.add(p);
            }
        }
    }

    @Override
    public void tickServer() {
        IItemHandler outputHandler;
        ItemStack seed = (ItemStack)this.inventory.get(1);
        ItemStack soil = (ItemStack)this.inventory.get(0);
        if (!seed.isEmpty()) {
            ClocheRecipe recipe = this.cachedRecipe.get();
            int consumption = (Integer)IEServerConfig.MACHINES.cloche_consumption.get();
            boolean consume = false;
            if (recipe != null && this.fertilizerAmount > 0 && this.energyStorage.extractEnergy(consumption, true) == consumption) {
                if (this.growth >= (float)recipe.getTime(seed, soil)) {
                    ItemStack existing;
                    int j;
                    NonNullList<ItemStack> outputs = recipe.getOutputs(seed, soil);
                    int canFit = 0;
                    boolean[] emptySlotsUsed = new boolean[4];
                    block0: for (ItemStack output : outputs) {
                        if (output.isEmpty()) continue;
                        for (j = 3; j < 7; ++j) {
                            existing = (ItemStack)this.inventory.get(j);
                            if ((!existing.isEmpty() || emptySlotsUsed[j - 3]) && (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)output) || existing.getCount() + output.getCount() > existing.getMaxStackSize())) continue;
                            ++canFit;
                            if (!existing.isEmpty()) continue block0;
                            emptySlotsUsed[j - 3] = true;
                            continue block0;
                        }
                    }
                    if (canFit >= outputs.size()) {
                        block2: for (ItemStack output : outputs) {
                            for (j = 3; j < 7; ++j) {
                                existing = (ItemStack)this.inventory.get(j);
                                if (existing.isEmpty()) {
                                    this.inventory.set(j, (Object)output.copy());
                                    continue block2;
                                }
                                if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)output) || existing.getCount() + output.getCount() > existing.getMaxStackSize()) continue;
                                existing.grow(output.getCount());
                                continue block2;
                            }
                        }
                        this.growth = 0.0f;
                        consume = true;
                    }
                } else {
                    this.growth = (float)((double)this.growth + (Double)IEServerConfig.MACHINES.cloche_growth_mod.get() * (double)this.fertilizerMod);
                    consume = true;
                    if (this.level.getGameTime() % 32L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x1F)) {
                        this.sendSyncPacket();
                    }
                }
                if (consume) {
                    this.energyStorage.extractEnergy(consumption, false);
                    --this.fertilizerAmount;
                    if (!this.renderActive) {
                        this.renderActive = true;
                        this.sendSyncPacket();
                    }
                }
            } else {
                this.growth = 0.0f;
                if (this.renderActive) {
                    this.renderActive = false;
                    this.sendSyncPacket();
                }
            }
            int fluidConsumption = (Integer)IEServerConfig.MACHINES.cloche_fluid.get();
            if (this.fertilizerAmount <= 0 && this.tank.getFluidAmount() >= fluidConsumption) {
                float itemMod;
                this.fertilizerMod = 1.0f;
                this.tank.drain(fluidConsumption, IFluidHandler.FluidAction.EXECUTE);
                ItemStack fertilizer = (ItemStack)this.inventory.get(2);
                if (!fertilizer.isEmpty() && (itemMod = ClocheFertilizer.getFertilizerGrowthModifier(this.level, fertilizer)) > 0.0f) {
                    this.fertilizerMod *= itemMod;
                    fertilizer.shrink(1);
                    if (fertilizer.getCount() <= 0) {
                        this.inventory.set(2, (Object)ItemStack.EMPTY);
                    }
                }
                this.fertilizerAmount = (Integer)IEServerConfig.MACHINES.cloche_fertilizer.get();
            }
        } else {
            this.growth = 0.0f;
        }
        if (this.level.getGameTime() % 8L == 0L && (outputHandler = this.output.getCapability()) != null) {
            for (int j = 3; j < 7; ++j) {
                ItemStack outStack = (ItemStack)this.inventory.get(j);
                if (outStack.isEmpty()) continue;
                int outCount = Math.min(outStack.getCount(), 16);
                ItemStack stack = outStack.copyWithCount(outCount);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).isEmpty()) {
                    outCount -= stack.getCount();
                }
                outStack.shrink(outCount);
                if (outStack.getCount() > 0) continue;
                this.inventory.set(j, (Object)ItemStack.EMPTY);
            }
        }
    }

    public float getGuiProgress() {
        ItemStack seed = (ItemStack)this.inventory.get(1);
        ItemStack soil = (ItemStack)this.inventory.get(0);
        ClocheRecipe recipe = this.cachedRecipe.get();
        if (recipe == null) {
            return 0.0f;
        }
        return Mth.clamp((float)(this.growth / (float)recipe.getTime(seed, soil)), (float)0.0f, (float)1.0f);
    }

    protected void sendSyncPacket() {
        CompoundTag nbt = new CompoundTag();
        nbt.putFloat("growth", this.growth);
        nbt.putBoolean("renderActive", this.renderActive);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new MessageBlockEntitySync(this.getBlockPos(), nbt), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void receiveMessageFromServer(CompoundTag message) {
        this.renderGrowth = message.getFloat("growth");
        this.renderActive = message.getBoolean("renderActive");
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ItemStack oldSoil = (ItemStack)this.inventory.get(0);
        this.dummy = nbt.getInt("dummy");
        Collections.fill(this.inventory, ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        this.fertilizerAmount = nbt.getInt("fertilizerAmount");
        this.fertilizerMod = nbt.getFloat("fertilizerMod");
        this.tank.readFromNBT(provider, nbt.getCompound("tank"));
        if (!descPacket) {
            EnergyHelper.deserializeFrom(this.energyStorage, nbt, provider);
            this.growth = nbt.getFloat("growth");
        }
        this.renderBB = null;
        if (descPacket && this.level != null && !ItemStack.matches((ItemStack)oldSoil, (ItemStack)((ItemStack)this.inventory.get(0)))) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.putInt("dummy", this.dummy);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        nbt.putInt("fertilizerAmount", this.fertilizerAmount);
        nbt.putFloat("fertilizerMod", this.fertilizerMod);
        CompoundTag tankTag = this.tank.writeToNBT(provider, new CompoundTag());
        nbt.put("tank", (Tag)tankTag);
        if (!descPacket) {
            EnergyHelper.serializeTo(this.energyStorage, nbt, provider);
            nbt.putFloat("growth", this.growth);
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public void setFacing(Direction facing) {
        BlockPos lowest = this.worldPosition.below(this.dummy);
        for (int i = 0; i < 3; ++i) {
            BlockPos pos = lowest.above(i);
            BlockState state = this.getLevelNonnull().getBlockState(pos);
            if (state.getBlock() != IEBlocks.MetalDevices.CLOCHE.get()) continue;
            this.getLevelNonnull().setBlockAndUpdate(pos, (BlockState)state.setValue(this.getFacingProperty(), (Comparable)facing));
        }
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    @Nullable
    public ClocheBlockEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterBE instanceof ClocheBlockEntity) {
            return (ClocheBlockEntity)this.tempMasterBE;
        }
        BlockPos masterPos = this.getBlockPos().below(this.dummy);
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return te instanceof ClocheBlockEntity ? (ClocheBlockEntity)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.level.setBlockAndUpdate(this.worldPosition.above(i), state);
            ((ClocheBlockEntity)this.level.getBlockEntity((BlockPos)this.worldPosition.above((int)i))).dummy = i;
            ((ClocheBlockEntity)this.level.getBlockEntity(this.worldPosition.above(i))).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterBE = this.master();
        for (int i = 0; i <= 2; ++i) {
            BlockPos p = this.getBlockPos().below(this.dummy).above(i);
            if (!(this.level.getBlockEntity(p) instanceof ClocheBlockEntity)) continue;
            this.level.removeBlock(p, false);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot == 2) {
            return ClocheFertilizer.isValidFertilizer(this.level, stack);
        }
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot < 2 ? 1 : 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
        this.markContainingBlockForUpdate(null);
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<ClocheBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, facing) -> {
            if (facing == null || be.dummy == 0 && facing.getAxis() == be.getFacing().getClockWise().getAxis() || be.dummy == 2 && facing == Direction.UP) {
                return be.energyCap.get();
            }
            return null;
        });
        registrar.register(Capabilities.ItemHandler.BLOCK, (be, facing) -> {
            Direction clocheFacing = be.getFacing();
            if (facing == null || be.dummy == 0 && facing.getAxis() != clocheFacing.getClockWise().getAxis()) {
                return be.inputHandler.get();
            }
            if (be.dummy == 1 && facing == clocheFacing.getOpposite()) {
                return be.outputHandler.get();
            }
            return null;
        });
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, facing) -> {
            if (facing == null || be.dummy == 0 && facing.getAxis() != be.getFacing().getClockWise().getAxis()) {
                return be.tankCap.get();
            }
            return null;
        });
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public ClocheBlockEntity getGuiMaster() {
        if (this.dummy == 0) {
            return this;
        }
        BlockEntity te = this.level.getBlockEntity(this.getBlockPos().below(this.dummy));
        if (te instanceof ClocheBlockEntity) {
            return (ClocheBlockEntity)te;
        }
        return null;
    }

    @Override
    public IEMenuTypes.ArgContainer<ClocheBlockEntity, ?> getContainerType() {
        return IEMenuTypes.CLOCHE;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        return new BlockPos(0, this.dummy, 0);
    }
}

