/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import malte0811.modelsplitter.model.UVCoords;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class ConnectionRenderer
implements ResourceManagerReloadListener {
    private static final LoadingCache<SectionKey, List<RenderedSegment>> SEGMENT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).build(CacheLoader.from(ConnectionRenderer::renderSectionForCache));
    private static final ResettableLazy<TextureAtlasSprite> WIRE_TEXTURE = new ResettableLazy<TextureAtlasSprite>(() -> Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(ImmersiveEngineering.rl("block/wire")));

    public void onResourceManagerReload(@Nonnull ResourceManager pResourceManager) {
        WIRE_TEXTURE.reset();
        ConnectionRenderer.resetCache();
    }

    public static void resetCache() {
        SEGMENT_CACHE.invalidateAll();
    }

    @SubscribeEvent
    public static void onSectionRender(AddSectionGeometryEvent ev) {
        BlockPos origin = ev.getSectionOrigin();
        SectionPos section = SectionPos.of((BlockPos)origin);
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(ev.getLevel());
        List<WireCollisionData.ConnectionSegments> connectionParts = globalNet.getCollisionData().getWiresIn(section);
        if (connectionParts != null && !connectionParts.isEmpty()) {
            ev.addRenderer(context -> ConnectionRenderer.renderConnectionsInSection(origin, context, connectionParts));
        }
    }

    public static void renderConnectionsInSection(BlockPos sectionOrigin, AddSectionGeometryEvent.SectionRenderingContext context, List<WireCollisionData.ConnectionSegments> segments) {
        VertexConsumer builder = context.getOrCreateChunkBuffer(RenderType.solid());
        PoseStack transform = context.getPoseStack();
        for (WireCollisionData.ConnectionSegments connection : segments) {
            transform.pushPose();
            ConnectionPoint connectionOrigin = connection.connection().getEndA();
            transform.translate((float)(connectionOrigin.getX() - sectionOrigin.getX()), (float)(connectionOrigin.getY() - sectionOrigin.getY()), (float)(connectionOrigin.getZ() - sectionOrigin.getZ()));
            ConnectionRenderer.renderSegments(builder, connection, context.getRegion(), transform);
            transform.popPose();
        }
    }

    public static void renderSegments(VertexConsumer out, WireCollisionData.ConnectionSegments toRender, BlockAndTintGetter level, PoseStack transform) {
        Connection connection = toRender.connection();
        int color = connection.type.getColour(connection);
        double radius = connection.type.getRenderDiameter() / 2.0;
        int lastLight = 0;
        List renderedSection = (List)SEGMENT_CACHE.getUnchecked((Object)new SectionKey(radius, color, connection.getCatenaryData(), toRender.firstPointToRender(), toRender.lastPointToRender()));
        for (int i = 0; i < renderedSection.size(); ++i) {
            RenderedSegment segment = (RenderedSegment)renderedSection.get(i);
            if (i == 0) {
                lastLight = ConnectionRenderer.getLight(connection, segment.offsetStart, level);
            }
            int nextLight = ConnectionRenderer.getLight(connection, segment.offsetEnd, level);
            segment.render(lastLight, nextLight, out, transform);
            lastLight = nextLight;
        }
    }

    public static void renderConnection(VertexConsumer out, Connection.CatenaryData catenaryData, double radius, int color, int light) {
        List section = (List)SEGMENT_CACHE.getUnchecked((Object)new SectionKey(radius, color, catenaryData, 0, 16));
        PoseStack transform = new PoseStack();
        for (RenderedSegment renderedSegment : section) {
            renderedSegment.render(light, light, out, transform);
        }
    }

    private static List<RenderedSegment> renderSectionForCache(SectionKey key) {
        Connection.CatenaryData catenaryData = key.catenaryShape();
        ArrayList<RenderedSegment> segments = new ArrayList<RenderedSegment>(key.lastIndex - key.firstIndex);
        for (int startIndex = key.firstIndex; startIndex < key.lastIndex; ++startIndex) {
            ArrayList<Vertex> vertices = new ArrayList<Vertex>(16);
            Vec3 start = key.catenaryShape().getRenderPoint(startIndex);
            Vec3 end = key.catenaryShape().getRenderPoint(startIndex + 1);
            Vec3 horNormal = key.catenaryShape().isVertical() ? new Vec3(1.0, 0.0, 0.0) : new Vec3(-catenaryData.delta().z, 0.0, catenaryData.delta().x).normalize();
            Vec3 verticalNormal = start.subtract(end).cross(horNormal).normalize();
            Vec3 horRadius = horNormal.scale(key.radius());
            Vec3 verticalRadius = verticalNormal.scale(-key.radius());
            ConnectionRenderer.renderBidirectionalQuad(vertices, start, end, horRadius, key.color(), verticalNormal);
            ConnectionRenderer.renderBidirectionalQuad(vertices, start, end, verticalRadius, key.color(), horNormal);
            segments.add(new RenderedSegment(vertices, (Vec3i)BlockPos.containing((Position)start), (Vec3i)BlockPos.containing((Position)end)));
        }
        return segments;
    }

    private static int getLight(Connection connection, Vec3i point, BlockAndTintGetter level) {
        return LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)connection.getEndA().position().offset(point));
    }

    private static int getByte(int value, int lowestBit) {
        return value >> lowestBit & 0xFF;
    }

    private static void renderBidirectionalQuad(List<Vertex> out, Vec3 start, Vec3 end, Vec3 radius, int color, Vec3 positiveNormal) {
        int i;
        TextureAtlasSprite texture = WIRE_TEXTURE.get();
        UVCoords[] uvs = new UVCoords[]{new UVCoords((double)texture.getU0(), (double)texture.getV0()), new UVCoords((double)texture.getU1(), (double)texture.getV0()), new UVCoords((double)texture.getU1(), (double)texture.getV1()), new UVCoords((double)texture.getU0(), (double)texture.getV1())};
        Vec3[] vertices = new Vec3[]{start.add(radius), end.add(radius), end.subtract(radius), start.subtract(radius)};
        for (i = 0; i < vertices.length; ++i) {
            out.add(ConnectionRenderer.vertex(vertices[i], uvs[i], color, positiveNormal, i == 0 || i == 3));
        }
        for (i = vertices.length - 1; i >= 0; --i) {
            out.add(ConnectionRenderer.vertex(vertices[i], uvs[i], color, positiveNormal.scale(-1.0), i == 0 || i == 3));
        }
    }

    private static Vertex vertex(Vec3 point, UVCoords uv, int color, Vec3 normal, boolean lightForStart) {
        return new Vertex((float)point.x, (float)point.y, (float)point.z, (float)uv.u(), (float)uv.v(), (float)ConnectionRenderer.getByte(color, 16) / 255.0f, (float)ConnectionRenderer.getByte(color, 8) / 255.0f, (float)ConnectionRenderer.getByte(color, 0) / 255.0f, (float)normal.x, (float)normal.y, (float)normal.y, lightForStart);
    }

    private record SectionKey(double radius, int color, Connection.CatenaryData catenaryShape, int firstIndex, int lastIndex) {
    }

    private record RenderedSegment(List<Vertex> vertices, Vec3i offsetStart, Vec3i offsetEnd) {
        public void render(int lightStart, int lightEnd, VertexConsumer out, PoseStack transform) {
            for (Vertex v : this.vertices) {
                out.addVertex(transform.last(), v.posX, v.posY, v.posZ).setColor(v.red, v.green, v.blue, 1.0f).setUv(v.texU, v.texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(v.lightForStart ? lightStart : lightEnd).setNormal(transform.last(), v.normalX, v.normalY, v.normalZ);
            }
        }
    }

    private record Vertex(float posX, float posY, float posZ, float texU, float texV, float red, float green, float blue, float normalX, float normalY, float normalZ, boolean lightForStart) {
    }
}

