/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.SorterMenu;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SorterScreen
extends IEContainerScreen<SorterMenu> {
    private static final ResourceLocation TEXTURE = SorterScreen.makeTextureLocation("sorter");
    public static final Map<FilterBit, GuiButtonIE.ButtonTexture> BUTTON_TEXTURE_TRUE = Map.of(FilterBit.DAMAGE, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/damage")), FilterBit.COMPONENTS, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/components")), FilterBit.TAG, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/tags")));
    public static final Map<FilterBit, GuiButtonIE.ButtonTexture> BUTTON_TEXTURE_FALSE = Map.of(FilterBit.DAMAGE, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/no_damage")), FilterBit.COMPONENTS, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/no_components")), FilterBit.TAG, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/no_tags")));

    public SorterScreen(SorterMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageHeight = 244;
        this.inventoryLabelY = this.imageHeight - 91;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        for (int side = 0; side < 6; ++side) {
            int x = this.leftPos + 30 + side / 2 * 58;
            int y = this.topPos + 44 + side % 2 * 76;
            String s = I18n.get((String)("desc.immersiveengineering.info.blockSide." + String.valueOf(Direction.from3DDataValue((int)side))), (Object[])new Object[0]).substring(0, 1);
            RenderSystem.enableBlend();
            graphics.drawString(ClientUtils.font(), s, x - ClientUtils.font().width(s) / 2, y, -1429418804, true);
        }
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        for (Direction side : Direction.values()) {
            for (FilterBit bit : FilterBit.values()) {
                int sideId = side.ordinal();
                int x = this.leftPos + 3 + sideId / 2 * 58 + bit.ordinal() * 18;
                int y = this.topPos + 3 + sideId % 2 * 76;
                int sideFinal = sideId;
                GetterAndSetter<SorterBlockEntity.FilterConfig> value = ((SorterMenu)this.menu).filterMasks.get(side);
                GuiButtonBoolean b = new GuiButtonBoolean(x, y, 18, 18, (Component)Component.empty(), () -> bit.get((SorterBlockEntity.FilterConfig)value.get()), BUTTON_TEXTURE_FALSE.get((Object)bit), BUTTON_TEXTURE_TRUE.get((Object)bit), btn -> {
                    CompoundTag tag = new CompoundTag();
                    tag.put("sideConfigVal", SorterBlockEntity.FilterConfig.CODEC.toNBT((Object)bit.toggle((SorterBlockEntity.FilterConfig)value.get())));
                    tag.putInt("sideConfigId", sideFinal);
                    this.sendUpdateToServer(tag);
                    this.fullInit();
                }, (components, aBoolean) -> {
                    String[] split = I18n.get((String)bit.getTranslationKey(), (Object[])new Object[0]).split("<br>");
                    for (int i = 0; i < split.length; ++i) {
                        if (i == 0) {
                            components.add(Component.literal((String)split[i]));
                            continue;
                        }
                        components.add(TextUtils.applyFormat((Component)Component.literal((String)split[i]), ChatFormatting.GRAY));
                    }
                });
                this.addRenderableWidget((GuiEventListener)b);
            }
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        int side;
        IESlot.ItemHandlerGhost ghostSlot;
        if (!((SorterMenu)this.menu).getCarried().isEmpty()) {
            return;
        }
        Slot slot = this.hoveredSlot;
        if (slot instanceof IESlot.ItemHandlerGhost && (ghostSlot = (IESlot.ItemHandlerGhost)slot).hasItem() && ((SorterMenu)this.menu).filterMasks.get(Direction.from3DDataValue((int)(side = ghostSlot.getSlotIndex() / 8))).get().allowTags()) {
            ItemStack item = ghostSlot.getItem();
            ArrayList tagTooltip = Lists.newArrayList();
            MutableComponent name = Component.empty().append(item.getHoverName()).withStyle(item.getRarity().getStyleModifier());
            if (item.has(DataComponents.CUSTOM_NAME)) {
                name.withStyle(ChatFormatting.ITALIC);
            }
            tagTooltip.add(name);
            List<ResourceLocation> available = SorterBlockEntity.FilterTag.getAvailableForItem(item);
            if (available.isEmpty()) {
                tagTooltip.add(Component.translatable((String)"desc.immersiveengineering.info.filter.tag.none_available"));
            } else {
                tagTooltip.add(Component.translatable((String)"desc.immersiveengineering.info.filter.tag.selected_scroll"));
                Optional<ResourceLocation> selected = ((SorterMenu)this.menu).selectedTags.get(ghostSlot.getSlotIndex()).get();
                available.forEach(location -> {
                    boolean isSelected = selected.isPresent() && ((ResourceLocation)selected.get()).equals(location);
                    SorterBlockEntity.FilterTag filterTag = SorterBlockEntity.FilterTag.deserialize(item, location);
                    tagTooltip.add(Component.literal((String)(isSelected ? " -> " : " > ")).append((Component)(filterTag != null ? filterTag.getComponent() : Component.literal((String)"ERROR: UNKNOWN TAG"))).withStyle(isSelected ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY));
                });
            }
            guiGraphics.renderTooltip(this.font, (List)tagTooltip, item.getTooltipImage(), item, x, y);
            return;
        }
        super.renderTooltip(guiGraphics, x, y);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        IESlot.ItemHandlerGhost ghostSlot;
        int side;
        Slot slot;
        if (((SorterMenu)this.menu).getCarried().isEmpty() && (slot = this.hoveredSlot) instanceof IESlot.ItemHandlerGhost && ((SorterMenu)this.menu).filterMasks.get(Direction.from3DDataValue((int)(side = (ghostSlot = (IESlot.ItemHandlerGhost)slot).getSlotIndex() / 8))).get().allowTags()) {
            ItemStack item = ghostSlot.getItem();
            List<ResourceLocation> tags = SorterBlockEntity.FilterTag.getAvailableForItem(item);
            if (tags.isEmpty()) {
                return false;
            }
            GetterAndSetter<Optional<ResourceLocation>> selected = ((SorterMenu)this.menu).selectedTags.get(ghostSlot.getSlotIndex());
            int index = selected.get().map(tags::indexOf).orElse(scrollY < 0.0 ? -1 : 0);
            ResourceLocation newTag = tags.get(Math.floorMod(index + (scrollY < 0.0 ? 1 : -1), tags.size()));
            selected.set(Optional.of(newTag));
            CompoundTag tag = new CompoundTag();
            tag.putInt("tagSlot", ghostSlot.getSlotIndex());
            tag.putString("selectedTag", newTag.toString());
            this.sendUpdateToServer(tag);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public static enum FilterBit {
        TAG,
        DAMAGE,
        COMPONENTS;


        public String getTranslationKey() {
            return "desc.immersiveengineering.info.filter." + this.name().toLowerCase(Locale.ROOT);
        }

        public boolean get(SorterBlockEntity.FilterConfig config) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> config.allowTags();
                case 2 -> config.considerComponents();
                case 1 -> config.ignoreDamage();
            };
        }

        public SorterBlockEntity.FilterConfig toggle(SorterBlockEntity.FilterConfig config) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new SorterBlockEntity.FilterConfig(!config.allowTags(), config.considerComponents(), config.ignoreDamage());
                case 2 -> new SorterBlockEntity.FilterConfig(config.allowTags(), !config.considerComponents(), config.ignoreDamage());
                case 1 -> new SorterBlockEntity.FilterConfig(config.allowTags(), config.considerComponents(), !config.ignoreDamage());
            };
        }
    }
}

