/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.shapes;

import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CachedShapesWithTransform<ShapeKey, TransformKey>
extends CachedVoxelShapes<Pair<ShapeKey, TransformKey>> {
    public CachedShapesWithTransform(Function<ShapeKey, List<AABB>> creator, BiFunction<TransformKey, AABB, AABB> transform) {
        super(p -> {
            List base = (List)creator.apply(p.getFirst());
            if (base == null) {
                return ImmutableList.of();
            }
            ArrayList<AABB> ret = new ArrayList<AABB>(base.size());
            for (AABB aabb : base) {
                ret.add((AABB)transform.apply(p.getSecond(), aabb));
            }
            return ret;
        });
    }

    public VoxelShape get(ShapeKey shapeKey, TransformKey transformKey) {
        return this.get(Pair.of(shapeKey, transformKey));
    }

    public static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> createForMultiblock(Function<BlockPos, List<AABB>> create) {
        return new CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>>(create, (key, box) -> CachedShapesWithTransform.withFacingAndMirror(box, (Direction)key.getFirst(), (Boolean)key.getSecond()));
    }

    public static AABB withFacingAndMirror(AABB in, Direction d, boolean mirror) {
        AABB mirrored = in;
        if (mirror) {
            mirrored = new AABB(1.0 - in.minX, in.minY, in.minZ, 1.0 - in.maxX, in.maxY, in.maxZ);
        }
        return ShapeUtils.transformAABB(mirrored, d);
    }

    public static <T> CachedShapesWithTransform<T, Direction> createDirectional(Function<T, List<AABB>> create) {
        return new CachedShapesWithTransform<T, Direction>(create, (key, box) -> ShapeUtils.transformAABB(box, key));
    }
}

