/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.utils.Color4;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;

public abstract class ShaderCase {
    protected ShaderLayer[] layers;

    protected ShaderCase(ShaderLayer ... layers) {
        this.layers = layers;
    }

    protected ShaderCase(Collection<ShaderLayer> layers) {
        this.layers = layers.toArray(new ShaderLayer[layers.size()]);
    }

    public ShaderLayer[] getLayers() {
        return this.layers;
    }

    public ShaderCase addLayers(ShaderLayer ... addedLayers) {
        this.addLayers(this.getLayerInsertionIndex(), addedLayers);
        return this;
    }

    public ShaderCase addLayers(int index, ShaderLayer ... addedLayers) {
        ShaderLayer[] newLayers = new ShaderLayer[this.layers.length + addedLayers.length];
        System.arraycopy(this.layers, 0, newLayers, 0, index);
        System.arraycopy(addedLayers, 0, newLayers, index, addedLayers.length);
        System.arraycopy(this.layers, index, newLayers, index + addedLayers.length, this.layers.length - index);
        this.layers = newLayers;
        return this;
    }

    public abstract int getLayerInsertionIndex();

    public abstract boolean shouldRenderGroupForPass(String var1, int var2);

    public abstract ResourceLocation getShaderType();

    public boolean stitchIntoSheet() {
        return true;
    }

    public ResourceLocation getTextureReplacement(String modelPart, int pass) {
        return this.getLayers()[pass].getTexture();
    }

    public Color4 getRenderColor(String modelPart, int pass, Color4 original) {
        return this.getLayers()[pass].getColor();
    }
}

