/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BottlingMachineRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<BottlingMachineRecipe>> SERIALIZER;
    public static final CachedRecipeList<BottlingMachineRecipe> RECIPES;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public final List<IngredientWithSize> inputs;
    public final SizedFluidIngredient fluidInput;
    public final TagOutputList output;

    public BottlingMachineRecipe(TagOutputList output, List<IngredientWithSize> inputs, SizedFluidIngredient fluidInput) {
        super(output.getLazyList().get(0), IERecipeTypes.BOTTLING_MACHINE, 60, 480, MULTIPLIERS);
        this.output = output;
        this.inputs = inputs;
        this.fluidInput = fluidInput;
        this.setInputListWithSizes(Lists.newArrayList(this.inputs));
        this.fluidInputList = Lists.newArrayList((Object[])new SizedFluidIngredient[]{fluidInput});
        this.outputList = this.output;
    }

    public BottlingMachineRecipe(TagOutputList output, IngredientWithSize input, SizedFluidIngredient fluidInput) {
        this(output, List.of(input), fluidInput);
    }

    protected IERecipeSerializer<BottlingMachineRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public boolean matches(ItemStack[] input, FluidStack fluid) {
        if (!this.fluidInput.test(fluid)) {
            return false;
        }
        HashMap<ItemStack, Integer> available = new HashMap<ItemStack, Integer>();
        for (ItemStack in : input) {
            available.put(in, in.getCount());
        }
        for (IngredientWithSize ingr : this.inputs) {
            int need = ingr.getCount();
            for (ItemStack stack : input) {
                if (!ingr.test(stack)) continue;
                int take = Math.min(need, (Integer)available.get(stack));
                available.put(stack, (Integer)available.get(stack) - (need -= take));
            }
            if (need <= 0) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getDisplayStacks(ItemStack[] input) {
        NonNullList list = NonNullList.withSize((int)this.inputs.size(), (Object)ItemStack.EMPTY);
        block0: for (int i = 0; i < this.inputs.size(); ++i) {
            for (ItemStack stack : input) {
                if (!this.inputs.get(i).test(stack)) continue;
                list.set(i, (Object)stack.copyWithCount(this.inputs.get(i).getCount()));
                continue block0;
            }
        }
        return list;
    }

    public static RecipeHolder<BottlingMachineRecipe> findRecipe(Level level, FluidStack fluid, ItemStack ... input) {
        if (fluid.isEmpty()) {
            return null;
        }
        for (RecipeHolder<BottlingMachineRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((BottlingMachineRecipe)recipe.value()).matches(input, fluid)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList<BottlingMachineRecipe>(IERecipeTypes.BOTTLING_MACHINE);
        MULTIPLIERS = SetRestrictedField.common();
    }
}

