/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.item;

import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.recipe.RecipeHelper;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PollenItem
extends Item {
    public PollenItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(TreeRegistrator.POLLEN_BLOCK_COMPONENT)) {
            Block leaf = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)pStack.get(TreeRegistrator.POLLEN_BLOCK_COMPONENT));
            pTooltipComponents.add((Component)Component.translatable((String)"productivetrees.pollen.name", (Object[])new Object[]{Component.translatable((String)leaf.getDescriptionId()).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.DARK_BLUE));
        }
        pTooltipComponents.add((Component)Component.translatable((String)"productivetrees.information.pollen").withStyle(ChatFormatting.GOLD));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (context.getPlayer() != null) {
            ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
            BlockState state = level.getBlockState(context.getClickedPos());
            if (stack.has(TreeRegistrator.POLLEN_BLOCK_COMPONENT) && state.is(BlockTags.LEAVES) && !state.is((Block)TreeRegistrator.POLLINATED_LEAVES.get())) {
                Block leafB = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)stack.get(TreeRegistrator.POLLEN_BLOCK_COMPONENT));
                RecipeHolder<TreePollinationRecipe> recipe = RecipeHelper.getPollinationRecipe(level, state, leafB.defaultBlockState());
                level.setBlock(context.getClickedPos(), ((Block)TreeRegistrator.POLLINATED_LEAVES.get()).defaultBlockState(), 3);
                BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
                if (blockEntity instanceof PollinatedLeavesBlockEntity) {
                    ResourceLocation backupItem;
                    PollinatedLeavesBlockEntity pollinatedLeavesBlockEntity = (PollinatedLeavesBlockEntity)blockEntity;
                    pollinatedLeavesBlockEntity.setLeafA(state.getBlock());
                    pollinatedLeavesBlockEntity.setLeafB(leafB);
                    ItemStack result = ItemStack.EMPTY;
                    ResourceLocation resourceLocation = backupItem = level.random.nextBoolean() ? BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()) : (ResourceLocation)stack.get(TreeRegistrator.POLLEN_BLOCK_COMPONENT);
                    if (recipe == null && backupItem != null) {
                        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)backupItem.getNamespace(), (String)backupItem.getPath().replace("leaves", "sapling")));
                        if (item != null) {
                            result = new ItemStack((ItemLike)item);
                        }
                    } else if (recipe != null) {
                        result = ((TreePollinationRecipe)recipe.value()).result;
                    }
                    pollinatedLeavesBlockEntity.setResult(result);
                    pollinatedLeavesBlockEntity.setChanged();
                    if (!context.getPlayer().isCreative()) {
                        stack.shrink(1);
                    }
                    context.getPlayer().swing(context.getHand());
                    level.levelEvent(2005, context.getClickedPos(), 0);
                }
            }
        }
        return super.useOn(context);
    }
}

