/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.inventory.StripperContainer;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StripperBlockEntity
extends CapabilityBlockEntity
implements MenuProvider,
UpgradeableBlockEntity {
    protected int tickCounter = 0;
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    public static int SLOT_AXE = 2;
    public static int SLOT_BARK = 3;
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(4, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (this.isInputSlotItem(slot, stack)) {
                return true;
            }
            if (!(slot != SLOT_OUT && slot != SLOT_BARK || stack.is(ModTags.STRIPPER_TOOLS) || StripperBlockEntity.this.canProcess(stack))) {
                ItemStack currentOutStack = this.getStackInSlot(slot);
                if (currentOutStack.isEmpty()) {
                    return true;
                }
                if (currentOutStack.getCount() < currentOutStack.getMaxStackSize()) {
                    return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentOutStack);
                }
            }
            return false;
        }

        public boolean isInputSlot(int slot) {
            return slot == SLOT_AXE || slot == SLOT_IN;
        }

        public boolean isInputSlotItem(int slot, ItemStack stack) {
            if (slot == SLOT_IN && stack.is(ItemTags.LOGS) && StripperBlockEntity.this.canProcess(stack) || slot == SLOT_AXE && stack.is(ModTags.STRIPPER_TOOLS)) {
                ItemStack currentOutStack = this.getStackInSlot(slot);
                return currentOutStack.isEmpty() || currentOutStack.getCount() < currentOutStack.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentOutStack);
            }
            return false;
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public int[] getOutputSlots() {
            return new int[]{SLOT_OUT, SLOT_BARK};
        }

        protected void onContentsChanged(int slot) {
            Level level;
            super.onContentsChanged(slot);
            if (slot == SLOT_AXE && (level = StripperBlockEntity.this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendBlockUpdated(StripperBlockEntity.this.getBlockPos(), StripperBlockEntity.this.getBlockState(), StripperBlockEntity.this.getBlockState(), 2);
            }
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get()));

    public StripperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeRegistrator.STRIPPER_BLOCK_ENTITY.get(), pos, state);
    }

    private boolean canProcess(ItemStack stack) {
        ItemStack stripped = TreeUtil.getStrippedItem(stack);
        return !stripped.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stripped);
    }

    public Component getName() {
        return Component.translatable((String)((Block)TreeRegistrator.STRIPPER.get()).getDescriptionId());
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StripperBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % 10 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack log = blockEntity.inventoryHandler.getStackInSlot(SLOT_IN);
            ItemStack axe = blockEntity.inventoryHandler.getStackInSlot(SLOT_AXE);
            ItemStack output = blockEntity.inventoryHandler.getStackInSlot(SLOT_OUT);
            if (!log.isEmpty() && !axe.isEmpty() && output.getCount() < output.getMaxStackSize()) {
                ItemStack strippedLogItem = TreeUtil.getStrippedItem(blockEntity, serverLevel, log);
                int speedModifier = 1 + blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()) + blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2;
                int itemCount = Math.min(Math.min(speedModifier, log.getCount()), output.getMaxStackSize() - output.getCount());
                strippedLogItem.setCount(itemCount);
                if (!strippedLogItem.isEmpty() && blockEntity.inventoryHandler.insertItem(SLOT_OUT, strippedLogItem, false).isEmpty()) {
                    ProductiveLogBlock logBlock;
                    TreeObject treeObject;
                    BlockItem blockItem;
                    Item item = log.getItem();
                    if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ProductiveLogBlock && (treeObject = TreeUtil.getTree((Block)(logBlock = (ProductiveLogBlock)item))) != null && treeObject.getStripDrop().isPresent()) {
                        blockEntity.inventoryHandler.insertItem(SLOT_BARK, treeObject.getStripDropStack().copy(), false);
                    }
                    log.shrink(itemCount);
                    if (axe.isDamageableItem()) {
                        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(TreeUtil.STRIPPER_UUID, "stripper"));
                        axe.hurtAndBreak(1, (LivingEntity)fakePlayer, EquipmentSlot.MAINHAND);
                    }
                }
            }
        }
    }

    public ItemStack getAxe() {
        return this.inventoryHandler.getStackInSlot(SLOT_AXE);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new StripperContainer(windowId, playerInventory, this);
    }
}

