/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.terminal;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.menu.implementations.MenuTypeBuilder;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.network.RequesterSyncPacket;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import com.almostreliable.merequester.requester.abstraction.RequestTracker;
import com.almostreliable.merequester.terminal.RequesterTerminalHost;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class RequesterTerminalMenu
extends AbstractRequesterMenu {
    public static final MenuType<RequesterTerminalMenu> TYPE = MenuTypeBuilder.create(RequesterTerminalMenu::new, RequesterTerminalHost.class).buildUnregistered(Utils.getRL("requester_terminal"));
    private final Long2ObjectOpenHashMap<RequestTracker> byId = new Long2ObjectOpenHashMap();
    private final Map<RequesterBlockEntity, RequestTracker> byRequester = new IdentityHashMap<RequesterBlockEntity, RequestTracker>();

    protected RequesterTerminalMenu(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
    }

    public void broadcastChanges() {
        if (this.isClientSide()) {
            return;
        }
        super.broadcastChanges();
        IGrid grid = this.getGrid();
        if (grid == null) {
            return;
        }
        VisitorState state = this.visitRequesters(grid);
        if (state.forceFullUpdate || state.total != this.byRequester.size()) {
            this.sendFullUpdate(grid);
        } else {
            this.sendPartialUpdate();
        }
    }

    protected int transferStackToMenu(ItemStack stack) {
        List<RequesterBlockEntity> requesters = this.byRequester.keySet().stream().sorted(Comparator.comparingLong(RequesterBlockEntity::getSortValue)).toList();
        for (RequesterBlockEntity requester : requesters) {
            int targetSlot = requester.getRequestManager().firstAvailableIndex();
            if (targetSlot == -1) continue;
            this.byRequester.get(requester).getServer().insertItem(targetSlot, stack, false);
            break;
        }
        return 0;
    }

    @Override
    protected void sendFullUpdate(@Nullable IGrid grid) {
        assert (grid != null);
        this.byId.clear();
        this.byRequester.clear();
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)RequesterSyncPacket.createClearData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        for (RequesterBlockEntity requester : grid.getActiveMachines(RequesterBlockEntity.class)) {
            this.byRequester.put(requester, this.createTracker(requester));
        }
        for (RequestTracker requestTracker : this.byRequester.values()) {
            this.byId.put(requestTracker.getId(), (Object)requestTracker);
            this.syncRequestTrackerFull(requestTracker);
        }
    }

    @Override
    protected void sendPartialUpdate() {
        for (RequestTracker requestTracker : this.byRequester.values()) {
            this.syncRequestTrackerPartial(requestTracker);
        }
    }

    @Override
    @Nullable
    protected RequestTracker getRequestTracker(long id) {
        return (RequestTracker)this.byId.get(id);
    }

    private VisitorState visitRequesters(IGrid grid) {
        VisitorState state = new VisitorState();
        for (RequesterBlockEntity requester : grid.getActiveMachines(RequesterBlockEntity.class)) {
            RequestTracker requestTracker = this.byRequester.get(requester);
            if (requestTracker == null || !requestTracker.getName().equals(requester.getTerminalName().getString())) {
                state.forceFullUpdate = true;
                return state;
            }
            ++state.total;
        }
        return state;
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private static class VisitorState {
        private int total;
        private boolean forceFullUpdate;

        private VisitorState() {
        }
    }
}

