/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.config.FuzzyMode;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.stacks.AEKey;
import com.almostreliable.merequester.core.Config;
import com.almostreliable.merequester.requester.RequestManager;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class StorageManager
implements IStorageWatcherNode,
INBTSerializable<CompoundTag> {
    private final RequesterBlockEntity host;
    private final Storage[] storages;
    @Nullable
    private IStackWatcher stackWatcher;

    StorageManager(RequesterBlockEntity host) {
        this.host = host;
        this.storages = new Storage[((Integer)Config.COMMON.requests.get()).intValue()];
    }

    public Storage get(int slot) {
        if (this.storages[slot] == null) {
            this.storages[slot] = new Storage();
        }
        return this.storages[slot];
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.stackWatcher = newWatcher;
        this.resetWatcher();
    }

    public void onStackChange(AEKey key, long amount) {
        for (int i = 0; i < this.storages.length; ++i) {
            if (!key.equals(this.host.getRequestManager().getKey(i))) continue;
            this.get((int)i).knownAmount = amount;
            this.get((int)i).pendingAmount = 0L;
        }
    }

    public long computeAmountToCraft(int slot) {
        RequestManager requests = this.host.getRequestManager();
        if (requests.getKey(slot) == null) {
            return 0L;
        }
        long storedAmount = this.get((int)slot).knownAmount + this.get((int)slot).pendingAmount;
        if (storedAmount < requests.getAmount(slot)) {
            return requests.get(slot).getBatch();
        }
        return 0L;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.storages.length; ++i) {
            tag.put(String.valueOf(i), (Tag)this.get(i).serializeNBT(registries));
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag tag) {
        for (int i = 0; i < this.storages.length; ++i) {
            this.get(i).deserializeNBT(registries, tag.getCompound(String.valueOf(i)));
        }
    }

    void addDrops(List<ItemStack> drops) {
        for (Storage storage : this.storages) {
            if (storage == null || storage.key == null) continue;
            storage.key.addDrops(storage.getBufferAmount() + storage.pendingAmount, drops, this.host.getLevel(), this.host.getBlockPos());
        }
    }

    void clear(int slot) {
        this.get((int)slot).knownAmount = -1L;
        this.computeKnownAmount(slot);
        this.resetWatcher();
    }

    private void populateWatcher(IStackWatcher watcher) {
        for (int i = 0; i < this.storages.length; ++i) {
            if (this.host.getRequestManager().getKey(i) == null) continue;
            watcher.add(this.host.getRequestManager().getKey(i));
        }
    }

    private void resetWatcher() {
        if (this.stackWatcher != null) {
            this.stackWatcher.reset();
            this.populateWatcher(this.stackWatcher);
        }
    }

    private void computeKnownAmount(int slot) {
        AEKey key = this.host.getRequestManager().getKey(slot);
        if (key == null) {
            return;
        }
        this.get((int)slot).knownAmount = this.host.getMainNodeGrid().getStorageService().getInventory().getAvailableStacks().get(key);
    }

    public static class Storage
    implements INBTSerializable<CompoundTag> {
        private static final String KEY_ID = "key";
        private static final String BUFFER_AMOUNT_ID = "buffer_amount";
        private static final String PENDING_AMOUNT_ID = "pending_amount";
        private static final String KNOWN_AMOUNT_ID = "known_amount";
        @Nullable
        private AEKey key;
        private long totalAmount;
        private long bufferAmount;
        private long pendingAmount;
        private long knownAmount = -1L;

        public CompoundTag serializeNBT(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            if (this.key != null) {
                tag.put(KEY_ID, (Tag)this.key.toTagGeneric(registries));
            }
            tag.putLong(BUFFER_AMOUNT_ID, this.bufferAmount);
            tag.putLong(PENDING_AMOUNT_ID, this.pendingAmount);
            tag.putLong(KNOWN_AMOUNT_ID, this.knownAmount);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider registries, CompoundTag tag) {
            this.key = tag.contains(KEY_ID) ? AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(KEY_ID)) : null;
            this.bufferAmount = tag.getLong(BUFFER_AMOUNT_ID);
            this.pendingAmount = tag.getLong(PENDING_AMOUNT_ID);
            this.knownAmount = tag.getLong(KNOWN_AMOUNT_ID);
        }

        public boolean compute(long inserted) {
            this.pendingAmount += inserted;
            this.bufferAmount = this.getBufferAmount() - inserted;
            this.totalAmount -= inserted;
            if (this.bufferAmount == 0L) {
                this.key = null;
            }
            return this.bufferAmount > 0L || this.totalAmount > 0L;
        }

        void update(AEKey key, long bufferAmount) {
            if (this.key != null && !key.fuzzyEquals(this.key, FuzzyMode.PERCENT_99)) {
                throw new IllegalArgumentException("storage key mismatch");
            }
            this.key = key;
            this.bufferAmount += bufferAmount;
        }

        public void setTotalAmount(long totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Nullable
        public AEKey getKey() {
            return this.key;
        }

        public long getBufferAmount() {
            return this.key == null ? 0L : this.bufferAmount;
        }

        public long getKnownAmount() {
            return this.knownAmount;
        }
    }
}

