/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util.item;

import com.google.common.collect.ImmutableList;
import dev.compactmods.machines.util.item.ItemHandlerScan;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemHandlerUtil {
    public static List<ItemStack> insertMultipleStacks(IItemHandler itemHandler, List<ItemStack> drops) {
        ArrayDeque<ItemStack> remainingDrops = new ArrayDeque<ItemStack>(drops);
        ImmutableList.Builder failedToPush = ImmutableList.builder();
        block0: while (!remainingDrops.isEmpty()) {
            ItemStack workingStack = (ItemStack)remainingDrops.pop();
            ItemHandlerScan scan = ItemHandlerScan.scanInventory(itemHandler, workingStack);
            if (!scan.hasSpaceAvailable()) {
                failedToPush.add((Object)workingStack);
                continue;
            }
            ArrayDeque<Integer> stackableSlots = new ArrayDeque<Integer>(scan.stacking());
            stackableSlots.addAll(scan.empty());
            boolean doneWithStack = false;
            while (!doneWithStack) {
                if (stackableSlots.isEmpty()) {
                    failedToPush.addAll(remainingDrops);
                    remainingDrops.clear();
                    continue block0;
                }
                Integer working = stackableSlots.peek();
                workingStack = itemHandler.insertItem(working.intValue(), workingStack, false);
                if (workingStack.isEmpty()) {
                    doneWithStack = true;
                    continue block0;
                }
                stackableSlots.pop();
                if (!stackableSlots.isEmpty()) continue;
                failedToPush.add((Object)workingStack.copy());
                doneWithStack = true;
            }
        }
        return failedToPush.build();
    }
}

