/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.feather.MemoryGraph;
import dev.compactmods.feather.edge.GraphEdge;
import dev.compactmods.feather.edge.impl.EmptyEdge;
import dev.compactmods.feather.node.Node;
import dev.compactmods.feather.traversal.GraphNodeTransformationFunction;
import dev.compactmods.machines.api.room.data.CMRoomDataLocations;
import dev.compactmods.machines.api.room.history.IPlayerEntryPointHistoryManager;
import dev.compactmods.machines.api.room.history.PlayerRoomHistoryEntry;
import dev.compactmods.machines.api.room.history.RoomEntryPoint;
import dev.compactmods.machines.api.room.history.RoomEntryResult;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import dev.compactmods.machines.player.PlayerEntryPointNode;
import dev.compactmods.machines.player.PlayerReferenceNode;
import dev.compactmods.machines.player.PlayerRoomEntryEdge;
import dev.compactmods.machines.room.graph.node.RoomReferenceNode;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlayerEntryPointHistoryManager
implements CodecHolder<PlayerEntryPointHistoryManager>,
CMDataFile,
IPlayerEntryPointHistoryManager {
    private static final Logger LOGS = LogManager.getLogger();
    public static final Codec<PlayerEntryPointHistoryManager> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("max_depth").forGetter(x -> x.maxDepth), (App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)PlayerRoomHistoryEntry.CODEC.listOf()).fieldOf("history").forGetter(PlayerEntryPointHistoryManager::playerRoomHistory)).apply((Applicative)inst, PlayerEntryPointHistoryManager::new));
    private final MemoryGraph graph = new MemoryGraph();
    private final int maxDepth;
    private final HashMap<String, RoomReferenceNode> roomNodes;
    private final HashMap<UUID, PlayerReferenceNode> playerNodes;
    private final HashMap<UUID, PlayerEntryPointNode> latestEntryPoints;
    private static final GraphNodeTransformationFunction<PlayerReferenceNode, Stream<PlayerRoomHistoryEntry>> PLAYER_TO_HISTORY = (graph, input) -> graph.outboundEdges((Node)input, PlayerEntryPointNode.class).flatMap(e -> graph.outboundEdges((Node)((PlayerEntryPointNode)e.target().get()), RoomReferenceNode.class, PlayerRoomEntryEdge.class)).map(PlayerEntryPointHistoryManager::fromEdge).sorted(Comparator.comparing(PlayerRoomHistoryEntry::instant).reversed());
    private static final GraphNodeTransformationFunction<PlayerReferenceNode, Stream<PlayerEntryPointNode>> PLAYER_TO_HISTORY_NODES = (graph, input) -> graph.outboundEdges((Node)input, PlayerEntryPointNode.class).flatMap(e -> graph.outboundEdges((Node)((PlayerEntryPointNode)e.target().get()), RoomReferenceNode.class, PlayerRoomEntryEdge.class)).sorted(Comparator.comparing(PlayerRoomEntryEdge::entryTime).reversed()).map(e -> (PlayerEntryPointNode)e.source().get());

    public PlayerEntryPointHistoryManager(int maxDepth) {
        this(maxDepth, Collections.emptyMap());
    }

    private PlayerEntryPointHistoryManager(int maxDepth, Map<UUID, List<PlayerRoomHistoryEntry>> history) {
        this.maxDepth = maxDepth;
        this.roomNodes = new HashMap();
        this.playerNodes = new HashMap();
        this.latestEntryPoints = new HashMap();
        for (Map.Entry<UUID, List<PlayerRoomHistoryEntry>> entry : history.entrySet()) {
            LOGS.debug("Loading history for player: " + String.valueOf(entry.getKey()));
            entry.getValue().stream().sorted(Comparator.comparing(PlayerRoomHistoryEntry::instant)).forEach(hist -> this.addRoomEntryUnsafe((UUID)entry.getKey(), (PlayerRoomHistoryEntry)hist));
        }
    }

    @Override
    public Path getDataLocation(MinecraftServer server) {
        return (Path)CMRoomDataLocations.PLAYER_SPAWNS.apply(server);
    }

    private static PlayerRoomHistoryEntry fromEdge(PlayerRoomEntryEdge edge) {
        return new PlayerRoomHistoryEntry(((RoomReferenceNode)edge.target().get()).code(), edge.entryTime(), ((PlayerEntryPointNode)edge.source().get()).data());
    }

    public void popHistory(Player player, int steps) {
        PlayerReferenceNode playerNode = this.playerNodes.get(player.getUUID());
        if (playerNode == null) {
            return;
        }
        Set<PlayerEntryPointNode> historyNodes = ((Stream)this.graph.transformFunc(PLAYER_TO_HISTORY_NODES, (Node)playerNode)).limit(steps).collect(Collectors.toSet());
        historyNodes.forEach(arg_0 -> ((MemoryGraph)this.graph).removeNode(arg_0));
        Optional<PlayerEntryPointNode> newLatest = ((Stream)this.graph.transformFunc(PLAYER_TO_HISTORY_NODES, (Node)playerNode)).findFirst();
        newLatest.ifPresentOrElse(l -> this.latestEntryPoints.replace(player.getUUID(), (PlayerEntryPointNode)l), () -> this.latestEntryPoints.remove(player.getUUID()));
    }

    public Optional<PlayerRoomHistoryEntry> lastHistory(Player player) {
        PlayerEntryPointNode lastEntry = this.latestEntryPoints.get(player.getUUID());
        if (lastEntry == null) {
            return Optional.empty();
        }
        return this.graph.outboundEdges((Node)lastEntry, RoomReferenceNode.class, PlayerRoomEntryEdge.class).max(Comparator.comparing(PlayerRoomEntryEdge::entryTime)).map(PlayerEntryPointHistoryManager::fromEdge);
    }

    public Stream<PlayerRoomHistoryEntry> history(Player player) {
        return this.history(player.getUUID());
    }

    public Stream<PlayerRoomHistoryEntry> history(UUID player) {
        PlayerReferenceNode playerNode = this.playerNodes.get(player);
        if (playerNode == null) {
            return Stream.empty();
        }
        return (Stream)this.graph.transformFunc(PLAYER_TO_HISTORY, (Node)playerNode);
    }

    private Map<UUID, List<PlayerRoomHistoryEntry>> playerRoomHistory() {
        return this.playerNodes.keySet().stream().collect(Collectors.toMap(pid -> pid, pid -> this.history((UUID)pid).toList()));
    }

    public RoomEntryResult enterRoom(UUID player, PlayerRoomHistoryEntry history) {
        return this.addRoomEntryUnsafe(player, history);
    }

    @NotNull
    private RoomEntryResult addRoomEntryUnsafe(UUID player, PlayerRoomHistoryEntry history) {
        PlayerReferenceNode playerNode = this.getOrCreatePlayer(player);
        long depth = this.graph.outboundEdges((Node)playerNode, PlayerEntryPointNode.class).count();
        if (depth >= (long)this.maxDepth) {
            return RoomEntryResult.FAILED_TOO_FAR_DOWN;
        }
        RoomReferenceNode roomNode = this.getOrCreateRoom(history.roomCode());
        PlayerEntryPointNode entryNode = new PlayerEntryPointNode(UUID.randomUUID(), history.entryPoint());
        if (this.latestEntryPoints.containsKey(player)) {
            PlayerEntryPointNode prev = this.latestEntryPoints.replace(player, entryNode);
            if (prev != null) {
                this.graph.connectNodes((Node)prev, (Node)entryNode, (GraphEdge)new EmptyEdge((Node)prev, (Node)entryNode));
            }
        } else {
            this.latestEntryPoints.put(player, entryNode);
        }
        this.graph.connectNodes((Node)playerNode, (Node)entryNode, (GraphEdge)new EmptyEdge((Node)playerNode, (Node)entryNode));
        this.graph.connectNodes((Node)entryNode, (Node)roomNode, (GraphEdge)new PlayerRoomEntryEdge(entryNode, roomNode, history.instant()));
        return RoomEntryResult.SUCCESS;
    }

    public RoomEntryResult enterRoom(Player player, String roomCode, RoomEntryPoint entryPoint) {
        return this.enterRoom(player.getUUID(), new PlayerRoomHistoryEntry(roomCode, Instant.now(), entryPoint));
    }

    @NotNull
    private RoomReferenceNode getOrCreateRoom(String roomCode) {
        return this.roomNodes.computeIfAbsent(roomCode, code -> {
            RoomReferenceNode node = new RoomReferenceNode(roomCode);
            this.graph.addNode((Node)node);
            return node;
        });
    }

    @NotNull
    private PlayerReferenceNode getOrCreatePlayer(UUID player) {
        return this.playerNodes.computeIfAbsent(player, o -> {
            PlayerReferenceNode node = new PlayerReferenceNode(UUID.randomUUID(), player);
            this.graph.addNode((Node)node);
            return node;
        });
    }

    public void clearHistory(ServerPlayer player) {
        if (!this.playerNodes.containsKey(player.getUUID())) {
            return;
        }
        PlayerReferenceNode playerNode = this.playerNodes.get(player.getUUID());
        List<Node> list = this.graph.successors((Node)playerNode).filter(PlayerEntryPointNode.class::isInstance).toList();
        for (Node node : list) {
            this.graph.removeNode(node);
        }
        this.latestEntryPoints.remove(player.getUUID());
    }

    @Override
    public Codec<PlayerEntryPointHistoryManager> codec() {
        return CODEC;
    }
}

