/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.util.potions.PotionHelper;

public class TippedArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(TippedArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private PotionContents potionContents = PotionContents.EMPTY;

    public TippedArrow(EntityType<TippedArrow> entityType, Level level) {
        super(entityType, level);
    }

    public TippedArrow(Level level, LivingEntity shooter, ItemStack pickupItemStack, @Nullable ItemStack projectileWeaponStack) {
        super(ModEntities.TIPPED_ARROW.get(), shooter, level, pickupItemStack, projectileWeaponStack);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.TIPPED_ARROW.get());
    }

    public void setPotionEffect(ItemStack stack) {
        this.potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        this.entityData.set(COLOR, (Object)this.potionContents.getColor());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && this.potionContents.hasEffects() && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
            this.potionContents = PotionContents.EMPTY;
            this.entityData.set(COLOR, (Object)0);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int color = this.getColor();
        if (color != 0 && particleCount > 0) {
            for (int j = 0; j < particleCount; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        PotionHelper.addPotionContentsToCompoundTag(compound, this.potionContents);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.potionContents = PotionHelper.getPotionContentsFromCompoundTag(compound);
        if (this.potionContents.hasEffects()) {
            this.entityData.set(COLOR, (Object)this.potionContents.getColor());
        }
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        Entity shooter = this.getOwner();
        if (shooter != null) {
            PotionHelper.applyEffectsToEntity(this.potionContents, (Entity)this, shooter, living);
        }
    }

    protected ItemStack getPickupItem() {
        if (!this.potionContents.hasEffects()) {
            return new ItemStack((ItemLike)Items.ARROW);
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.TIPPED_ARROW.get());
        stack.set(DataComponents.POTION_CONTENTS, (Object)this.potionContents);
        return stack;
    }

    public void handleEntityEvent(byte id) {
        if (id == 0) {
            int color = this.getColor();
            if (color > 0) {
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }
}

