/*
 * Decompiled with CFR 0.152.
 */
package reliquary;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import reliquary.client.init.ModParticles;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.data.DataGenerators;
import reliquary.handler.ClientEventHandler;
import reliquary.handler.CommonEventHandler;
import reliquary.init.ModBlocks;
import reliquary.init.ModCompat;
import reliquary.init.ModDataComponents;
import reliquary.init.ModEffects;
import reliquary.init.ModEntities;
import reliquary.init.ModFluids;
import reliquary.init.ModItems;
import reliquary.init.ModPayloads;
import reliquary.init.ModSounds;
import reliquary.init.PedestalItems;
import reliquary.item.MobCharmRegistry;
import reliquary.reference.Config;
import reliquary.util.potions.PotionMap;

@Mod(value="reliquary")
public class Reliquary {
    public static final String MOD_ID = "reliquary";

    public Reliquary(IEventBus modBus, Dist dist, ModContainer container) {
        NeoForgeMod.enableMilkFluid();
        if (dist == Dist.CLIENT) {
            ClientEventHandler.registerHandlers(container);
        }
        modBus.addListener(Reliquary::setup);
        modBus.addListener(Reliquary::loadComplete);
        modBus.addListener(Config::onFileChange);
        modBus.addListener(DataGenerators::gatherData);
        modBus.addListener(ModPayloads::registerPackets);
        ModFluids.registerHandlers(modBus);
        ModItems.registerListeners(modBus);
        ModBlocks.registerListeners(modBus);
        ModEntities.registerListeners(modBus);
        ModEffects.registerListeners(modBus);
        ModSounds.registerListeners(modBus);
        ModParticles.registerListeners(modBus);
        ModDataComponents.register(modBus);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        CommonEventHandler.registerEventBusListeners(eventBus);
        eventBus.addListener(MobCharmRegistry::handleAddingFragmentDrops);
        eventBus.addListener(AlkahestryRecipeRegistry::onResourceReload);
        ModCompat.initCompats(modBus);
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModItems::registerDispenseBehaviors);
        PotionMap.initPotionMap();
        ModItems.registerHandgunMagazines();
        PedestalItems.init();
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        MobCharmRegistry.registerDynamicCharmDefinitions();
    }

    public static ResourceLocation getRL(String regName) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)regName);
    }
}

