/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.datagen;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.datagen.BlockStateDataGen;
import tv.soaryn.xycraft.core.datagen.ConnectedModelProvider;
import tv.soaryn.xycraft.core.datagen.CoreResources;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.XyWorld;
import tv.soaryn.xycraft.world.content.blocks.SidedLightSourceBlock;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class WorldBlockStateDataGen
extends BlockStateDataGen {
    public WorldBlockStateDataGen(PackOutput output, ContentMap registry, String modId, ExistingFileHelper exFileHelper) {
        super(output, registry.ListOfBlocks, modId, exFileHelper);
    }

    protected void registerStatesAndModels() {
        super.registerStatesAndModels();
        this.buildConnectedBlock(WorldContent.Block.GlassViewerDark, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        this.buildConnectedBlock(WorldContent.Block.GlassViewerPhantom, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        this.buildConnectedBlock(WorldContent.Block.GlassViewerPhantomGlowing, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        this.buildConnectedBlock(WorldContent.Block.GlassViewerPhantomDark, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        WorldContent.Block.AureyBlockMatte.values().forEach(blockContent -> {
            blockContent.withModelPath("aluminum_storage");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setTintIndex(0).end().renderType("cutout").texture("particle", "xycraft_world:block/connected/aluminum_storage_single"));
        });
        WorldContent.Block.AureyBlockMatteGlowing.values().forEach(blockContent -> {
            blockContent.withModelPath("aluminum_storage");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setTintIndex(0).end().renderType("cutout").texture("particle", "xycraft_world:block/connected/aluminum_storage_single"));
        });
        WorldContent.Block.AureyBlockFx.values().forEach(blockContent -> {
            blockContent.withModelPath("aurey_cloud");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).setTintIndex(0).end().renderType("cutout").texture("particle", CoreResources.CloudFX).texture("base", CoreResources.CloudFX));
        });
        WorldContent.Block.AureyBlockFxGlowing.values().forEach(blockContent -> {
            blockContent.withModelPath("aurey_cloud");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).setTintIndex(0).end().renderType("cutout").texture("particle", CoreResources.CloudFX).texture("base", CoreResources.CloudFX));
        });
        WorldContent.Block.GlassViewerRgb.values().forEach(blockContent -> this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("translucent").texture("particle", "xycraft_world:block/connected/glass_viewer_rgb_base").texture("base", "xycraft_world:block/connected/glass_viewer_rgb_base")));
        WorldContent.Block.GlassViewerRgbGlowing.values().forEach(blockContent -> {
            blockContent.withModelPath(WorldContent.Block.GlassViewerRgb.get(DyeColors.White).modelPath());
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("translucent").texture("particle", "xycraft_world:block/connected/glass_viewer_rgb_base").texture("base", "xycraft_world:block/connected/glass_viewer_rgb_base"));
        });
        WorldContent.Block.KiviTrim.values().forEach(wrapper -> this.buildConnectedBlock((BlockContent)wrapper, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("cutout").texture("base", CoreResources.CloudFX).texture("particle", CoreResources.CloudFX)));
        WorldContent.Block.AluminumTrim.values().forEach(wrapper -> this.buildConnectedBlock((BlockContent)wrapper, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("cutout").texture("base", CoreResources.CloudFX).texture("particle", CoreResources.CloudFX)));
        WorldContent.Block.ImmortalAluminum.values().forEach(wrapper -> this.buildConnectedBlock((BlockContent)wrapper, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("cutout").texture("base", CoreResources.CloudFX).texture("particle", CoreResources.CloudFX)));
        WorldContent.Block.ImmortalStone.values().forEach(wrapper -> this.buildConnectedBlock((BlockContent)wrapper, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("cutout").texture("base", CoreResources.CloudFX).texture("particle", CoreResources.CloudFX)));
        WorldContent.Block.XychoriumStorage.values().forEach(wrapper -> this.buildConnectedBlock((BlockContent)wrapper, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).setTintIndex(0).end().renderType("cutout").texture("base", CoreResources.CloudFX).texture("particle", CoreResources.CloudFX)));
        WorldContent.Block.InvertedBricksCloud.forEach((customColors, blockContent) -> {
            BlockModelBuilder model = (BlockModelBuilder)this.cloudModelTintable("xycraft_world:" + blockContent.id().getPath(), (BlockContent)blockContent).texture("tex", "xycraft_world:block/" + blockContent.modelPath());
            this.simpleBlock(blockContent.block(), (ModelFile)model);
        });
        WorldContent.Block.InvertedTilesCloud.forEach((customColors, blockContent) -> {
            BlockModelBuilder model = (BlockModelBuilder)this.cloudModelTintable("xycraft_world:" + blockContent.id().getPath(), (BlockContent)blockContent).texture("tex", "xycraft_world:block/" + blockContent.modelPath());
            this.simpleBlock(blockContent.block(), (ModelFile)model);
        });
        String lampModelPath = WorldContent.Block.LampRgbGlowing.get(DyeColors.White).modelPath();
        BlockModelBuilder lampModel = (BlockModelBuilder)((ConnectedModelProvider)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(lampModelPath, "block/block")).texture("texture_single", "xycraft_world:block/connected/" + lampModelPath + "_single")).texture("texture_connected", "xycraft_world:block/connected/" + lampModelPath)).texture("base", CoreResources.CloudFX)).texture("particle", CoreResources.CloudFX)).renderType("cutout")).customLoader(ConnectedModelProvider::new)).setBaseEmissivity(15).setBaseTintIndex(0).end();
        WorldContent.Block.LampRgbGlowing.values().forEach(content -> this.simpleBlock(content.block(), (ModelFile)lampModel));
        WorldContent.Block.LampRgbGlowingInverted.values().forEach(content -> this.simpleBlock(content.block(), (ModelFile)lampModel));
        WorldContent.Block.AluminumPillar.forEach((customColors, blockContent) -> {
            BlockModelBuilder horizontalModel = (BlockModelBuilder)((BlockModelBuilder)this.cloudModelPillar("xycraft_world:" + blockContent.id().getPath() + "_horizontal", "minecraft:block/block", (BlockContent)blockContent).texture("end", "xycraft_world:block/aluminum_pillar_top")).texture("side", "xycraft_world:block/aluminum_pillar");
            BlockModelBuilder verticalModel = (BlockModelBuilder)((BlockModelBuilder)this.cloudModelPillar("xycraft_world:" + blockContent.id().getPath(), "minecraft:block/block", (BlockContent)blockContent).texture("end", "xycraft_world:block/aluminum_pillar_top")).texture("side", "xycraft_world:block/aluminum_pillar");
            this.buildCloudPillar((BlockContent)blockContent, verticalModel, horizontalModel);
        });
        WorldContent.Block.KiviPillar.forEach((customColors, blockContent) -> {
            BlockModelBuilder horizontalModel = (BlockModelBuilder)((BlockModelBuilder)this.cloudModelPillar("xycraft_world:" + blockContent.id().getPath() + "_horizontal", "minecraft:block/block", (BlockContent)blockContent).texture("end", "xycraft_world:block/kivi_pillar_top")).texture("side", "xycraft_world:block/kivi_pillar");
            BlockModelBuilder verticalModel = (BlockModelBuilder)((BlockModelBuilder)this.cloudModelPillar("xycraft_world:" + blockContent.id().getPath(), "minecraft:block/block", (BlockContent)blockContent).texture("end", "xycraft_world:block/kivi_pillar_top")).texture("side", "xycraft_world:block/kivi_pillar");
            this.buildCloudPillar((BlockContent)blockContent, verticalModel, horizontalModel);
        });
        ModelFile.ExistingModelFile mount = this.models().getExistingFile(XyWorld.resource("block/lamp_mount/mount"));
        ModelFile.ExistingModelFile mountXl = this.models().getExistingFile(XyWorld.resource("block/lamp_mount/mount_xl"));
        ModelFile.ExistingModelFile lantern = this.models().getExistingFile(XyWorld.resource("block/lamp_lantern/lantern"));
        ModelFile.ExistingModelFile hanging = this.models().getExistingFile(XyWorld.resource("block/lamp_lantern/lantern_hanging"));
        WorldContent.Block.LampLantern.forEach((dyeColor, blockContent) -> ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(blockContent.block()).part().modelFile((ModelFile)lantern).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)hanging).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)mount).rotationX(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.UP}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.UP}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end());
        ModelFile.ExistingModelFile flush = this.models().getExistingFile(XyWorld.resource("block/lamp_flush/lamp_flush"));
        ModelFile.ExistingModelFile flushXl = this.models().getExistingFile(XyWorld.resource("block/lamp_flush/lamp_flush_xl"));
        WorldContent.Block.LampFlush.forEach((dyeColor, blockContent) -> ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockContent.block()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.DOWN).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)flush).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.DOWN).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)flushXl).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.UP).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)flush).rotationX(180).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.UP).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)flushXl).rotationX(180).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.NORTH).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)flush).rotationX(90).rotationY(180).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.NORTH).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)flushXl).rotationX(90).rotationY(180).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.SOUTH).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)flush).rotationX(90).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.SOUTH).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)flushXl).rotationX(90).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.WEST).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)flush).rotationX(90).rotationY(90).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.WEST).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)flushXl).rotationX(90).rotationY(90).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.EAST).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)flush).rotationX(90).rotationY(270).addModel()).partialState().with((Property)CoreStateProperties.StateDirection, (Comparable)Direction.EAST).with((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)flushXl).rotationX(90).rotationY(270).addModel());
        ModelFile.ExistingModelFile lampCube = this.models().getExistingFile(XyWorld.resource("block/lamp_cube/lamp_cube"));
        WorldContent.Block.LampCube.values().forEach(blockContent -> ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(blockContent.block()).part().modelFile((ModelFile)lampCube).addModel()).end().part().modelFile((ModelFile)mount).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.DOWN}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.DOWN}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.UP}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.UP}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).rotationY(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).rotationY(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).rotationY(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).rotationY(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).rotationY(270).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).rotationY(270).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end());
        ModelFile.ExistingModelFile lampPillar = this.models().getExistingFile(XyWorld.resource("block/lamp_pillar/lamp_pillar"));
        WorldContent.Block.LampPillar.values().forEach(blockContent -> ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(blockContent.block()).part().modelFile((ModelFile)lampPillar).addModel()).condition((Property)CoreStateProperties.Axis, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)lampPillar).rotationX(90).rotationY(90).addModel()).condition((Property)CoreStateProperties.Axis, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)lampPillar).rotationX(90).addModel()).condition((Property)CoreStateProperties.Axis, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)mount).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.DOWN}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.DOWN}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.UP}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.UP}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).rotationY(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).rotationY(180).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).rotationY(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).rotationY(90).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)mount).rotationX(90).rotationY(270).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)mountXl).rotationX(90).rotationY(270).addModel()).condition((Property)CoreStateProperties.StateDirection, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)SidedLightSourceBlock.StateProperties.Xl, (Comparable[])new Boolean[]{true}).end());
    }
}

