/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.core.utils.ShapeUtils;

public abstract class SidedLightSourceBlock
extends SidePartBlock
implements IColoredBlock {
    protected final IColorSource _color;
    public static final VoxelShape MountShape = SidedLightSourceBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    public static final VoxelShape MountShapeXl = SidedLightSourceBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);

    @NotNull
    protected static IBlockCapabilityProvider<IColorable, Void> coloredLampProvider(final EnumMap<DyeColors, BlockContent> map) {
        return (level, pos, state, blockEntity, context) -> new IColorable(){

            public int getColor(int index) {
                Block block = state.getBlock();
                if (block instanceof SidedLightSourceBlock) {
                    SidedLightSourceBlock lamp = (SidedLightSourceBlock)block;
                    return lamp._color.getColor();
                }
                return -1;
            }

            @NotNull
            public IColorable.Result setColor(int index, int value) {
                DyeColors dyeColor = ColorUtils.getClosestDyeColor((int)value, (DyeColors)DyeColors.White);
                Block newBlock = ((BlockContent)map.get(dyeColor)).block();
                if (newBlock == state.getBlock()) {
                    return IColorable.Result.DENIED;
                }
                level.setBlockAndUpdate(pos, newBlock.withPropertiesOf(state));
                return IColorable.Result.SUCCESS;
            }
        };
    }

    @NotNull
    public static Reference2ObjectOpenHashMap<Direction, VoxelShape> cacheShape(VoxelShape core, VoxelShape mountShape) {
        return Direction.stream().collect(Collectors.toMap(Function.identity(), direction -> Shapes.or((VoxelShape)core, (VoxelShape)ShapeUtils.rotate((VoxelShape)mountShape, (Direction)direction)), (o, o2) -> o, Reference2ObjectOpenHashMap::new));
    }

    public SidedLightSourceBlock(IColorSource color, BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().destroyTime(2.0f));
        this._color = color;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)StateProperties.Xl, (Comparable)Boolean.valueOf(false)));
    }

    public abstract EnumSet<Direction> getValidMountDirections();

    @NotNull
    public abstract VoxelShape getShape(@NotNull BlockState var1, @NotNull BlockGetter var2, @NotNull BlockPos var3, @NotNull CollisionContext var4);

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{StateProperties.Xl});
    }

    protected abstract EnumMap<DyeColors, BlockContent> getCurrentMap(int var1, BlockState var2);

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, Player player) {
        if (player.isCreative()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        EnumMap<DyeColors, BlockContent> currentMap = this.getCurrentMap(0, state);
        return new ItemStack((ItemLike)currentMap.get(DyeColors.White).block(), 1);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Player player = context.getPlayer();
        ItemStack offhandStack = player == null ? ItemStack.EMPTY : player.getOffhandItem();
        BlockState state = super.getStateForPlacement(context);
        if (state == null || !this.getValidMountDirections().contains(context.getClickedFace().getOpposite())) {
            return null;
        }
        DyeColors color = DyeColors.from((DyeColor)DyeColor.getColor((ItemStack)offhandStack));
        if (color != null) {
            state = this.getCurrentMap(15, state).get(color).block().withPropertiesOf(state);
        }
        return state;
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean p_54758_) {
        super.onPlace(blockState, level, pos, oldState, p_54758_);
        level.invalidateCapabilities(pos);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onRemove(state, level, pos, oldState, moving);
        level.invalidateCapabilities(pos);
    }

    public static boolean dye(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, EnumMap<DyeColor, BlockContent> currentMap, DyeColor dyeColor) {
        BlockContent blockType = currentMap.get(dyeColor);
        if (dyeColor == null || blockType.block() == state.getBlock()) {
            return false;
        }
        BlockState newState = blockType.block().withPropertiesOf(state);
        level.setBlock(pos, newState, 11);
        return true;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return this._color.getColor();
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return this._color.getColor();
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return type == PathComputationType.AIR;
    }

    public static interface StateProperties {
        public static final BooleanProperty Xl = BooleanProperty.create((String)"xl");
    }
}

