/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.ManualItemHandler;
import cy.jdkdigital.generatorgalore.common.datamap.PotionComponentIngredient;
import cy.jdkdigital.generatorgalore.common.datamap.SolidFuelMap;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GeneratorUtil {
    public static ResourceLocation EMPTY_TAG = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"empty");
    public static String FUEL_SOLID = "SOLID";
    public static String FUEL_FLUID = "FLUID";
    public static String FUEL_FOOD = "FOOD";
    public static String FUEL_ENCHANTMENT = "ENCHANTMENT";
    public static final Path LOCK_FILE = GeneratorUtil.createCustomPath("");
    public static final Path GENERATORS = GeneratorUtil.createCustomPath("generator");

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "generatorgalore", pathName);
        GeneratorUtil.createDirectory(customPath, pathName);
        return customPath;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            GeneratorGalore.LOGGER.error("failed to create \"" + dirName + "\" directory");
        }
    }

    public static void replaceGenerator(Level level, BlockPos pos, GeneratorObject generator) {
        BlockState existingGenerator = level.getBlockState(pos);
        BlockState newGenerator = (BlockState)((BlockState)generator.getBlockSupplier().get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)existingGenerator.getValue((Property)HorizontalDirectionalBlock.FACING)))).setValue((Property)BlockStateProperties.LIT, (Comparable)((Boolean)existingGenerator.getValue((Property)BlockStateProperties.LIT)));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            CompoundTag tag = generatorBlockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            ManualItemHandler manualItemHandler = generatorBlockEntity.inventoryHandler;
            if (manualItemHandler instanceof ItemStackHandler) {
                ManualItemHandler itemHandler = manualItemHandler;
                itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                itemHandler.setStackInSlot(1, ItemStack.EMPTY);
            }
            level.setBlockAndUpdate(pos, newGenerator);
            level.getBlockEntity(pos).loadCustomOnly(tag, (HolderLookup.Provider)level.registryAccess());
        }
    }

    public static Pair<Float, Integer> calculateFoodGenerationRate(GeneratorObject generator, ItemStack stack) {
        FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, null);
        if (foodProperties != null) {
            int value = foodProperties.nutrition();
            float saturation = foodProperties.saturation();
            double totalRF = (float)value * saturation * 8000.0f;
            return Pair.of((Object)Float.valueOf((float)((double)value * generator.getOriginalGenerationRate())), (Object)((int)(totalRF / generator.getGenerationRate())));
        }
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)generator.getConsumptionRate()));
    }

    public static Pair<Float, Integer> calculateEnchantmentGenerationRate(GeneratorObject generator, ItemStack stack) {
        if (stack.isEnchanted() || stack.getItem() instanceof EnchantedBookItem) {
            double totalRF = 0.0;
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                float level = entry.getValue().intValue();
                float max = enchantment.getMaxLevel();
                float min = enchantment.getMinCost(entry.getValue().intValue());
                float weight = enchantment.getWeight();
                totalRF += Math.abs(Math.sqrt(Math.min((double)level + 1.0, (double)max) / (double)max) * Math.pow(max, 2.0) * (double)(level + 1.0f) * ((double)min / Math.sqrt(weight))) * 400.0;
            }
            return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)(totalRF / generator.getGenerationRate())));
        }
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)generator.getConsumptionRate()));
    }

    public static Pair<Float, Integer> calculatePotionGenerationRate(Level level, GeneratorObject generator, ItemStack stack) {
        List<SolidFuelMap.SolidFuel> fuels = GeneratorUtil.getPotionFuels((HolderLookup.Provider)level.registryAccess());
        for (SolidFuelMap.SolidFuel fuel : fuels) {
            if (!fuel.item().test(stack)) continue;
            return Pair.of((Object)Float.valueOf(fuel.generationRate()), (Object)((int)fuel.consumptionRate()));
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)1);
    }

    public static List<SolidFuelMap.SolidFuel> getPotionFuels(HolderLookup.Provider provider) {
        ArrayList<SolidFuelMap.SolidFuel> potionFuels = new ArrayList<SolidFuelMap.SolidFuel>();
        provider.lookup(Registries.POTION).ifPresent(potionRegistryLookup -> {
            GeneratorUtil.generatePotionEffectTypes(potionFuels, (HolderLookup<Potion>)potionRegistryLookup, Items.POTION);
            GeneratorUtil.generatePotionEffectTypes(potionFuels, (HolderLookup<Potion>)potionRegistryLookup, Items.SPLASH_POTION);
            GeneratorUtil.generatePotionEffectTypes(potionFuels, (HolderLookup<Potion>)potionRegistryLookup, Items.LINGERING_POTION);
        });
        return potionFuels;
    }

    private static void generatePotionEffectTypes(List<SolidFuelMap.SolidFuel> potionFuels, HolderLookup<Potion> potions, Item item) {
        potions.listElements().map(potion -> {
            ItemStack stack = PotionContents.createItemStack((Item)item, (Holder)potion);
            int burnTime = 0;
            for (MobEffectInstance mobEffectInstance : ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).getAllEffects()) {
                burnTime += 3 * (1 + mobEffectInstance.getAmplifier()) * (mobEffectInstance.getDuration() * 3) + (potion.getKey().location().getPath().contains("strong_") ? 6000 : 0);
            }
            return new SolidFuelMap.SolidFuel(PotionComponentIngredient.of(stack), 1.0f, burnTime, 8);
        }).forEach(potionFuels::add);
    }

    public static enum FuelType implements StringRepresentable
    {
        SOLID("SOLID"),
        FLUID("FLUID"),
        FOOD("FOOD"),
        ENCHANTMENT("ENCHANTMENT"),
        POTION("POTION");

        private final String key;
        public static StringRepresentable.EnumCodec<FuelType> CODEC;

        private FuelType(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FuelType::values);
        }
    }
}

