/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class FluidContainerUtil {
    private static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    private static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void setColors(int color) {
        RenderSystem.setShaderColor((float)FluidContainerUtil.getRed(color), (float)FluidContainerUtil.getGreen(color), (float)FluidContainerUtil.getBlue(color), (float)FluidContainerUtil.getAlpha(color));
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void renderFluidTank(GuiGraphics matrices, AbstractContainerScreen<?> screen, FluidStack stack, int capacity, int x, int y, int width, int height, int depth) {
        FluidContainerUtil.renderFluidTank(matrices, screen, stack, stack.getAmount(), capacity, x, y, width, height, depth);
    }

    public static void renderFluidTank(GuiGraphics matrices, AbstractContainerScreen<?> screen, FluidStack stack, int amount, int capacity, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty() && capacity > 0) {
            int maxY = y + height;
            int fluidHeight = Math.min(height * amount / capacity, height);
            FluidContainerUtil.renderTiledFluid(matrices, screen, stack, x, maxY - fluidHeight, width, fluidHeight, depth);
        }
    }

    public static void renderTiledFluid(GuiGraphics matrices, AbstractContainerScreen<?> screen, FluidStack stack, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty()) {
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
            TextureAtlasSprite fluidSprite = (TextureAtlasSprite)screen.getMinecraft().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(attributes.getStillTexture());
            FluidContainerUtil.setColors(attributes.getTintColor());
            FluidContainerUtil.renderTiledTextureAtlas(matrices, screen, fluidSprite, x, y, width, height, depth, false);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderTiledTextureAtlas(GuiGraphics matrices, AbstractContainerScreen<?> screen, TextureAtlasSprite sprite, int x, int y, int width, int height, int depth, boolean upsideDown) {
        FluidContainerUtil.bindTexture(sprite.atlasLocation());
        int spriteHeight = sprite.contents().height();
        int spriteWidth = sprite.contents().width();
        int startX = x + screen.getGuiLeft();
        int startY = y + screen.getGuiTop();
        Matrix4f matrix = matrices.pose().last().pose();
        int xTileCount = width / spriteWidth;
        int xRemainder = width - xTileCount * spriteWidth;
        long yTileCount = height / spriteHeight;
        long yRemainder = (long)height - yTileCount * (long)spriteHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int widthLeft = xTile == xTileCount ? xRemainder : spriteWidth;
                long heightLeft = (long)yTile == yTileCount ? yRemainder : (long)spriteHeight;
                int x2 = startX + xTile * spriteWidth;
                int y2 = startY + height - (yTile + 1) * spriteHeight;
                if (widthLeft > 0 && heightLeft > 0L) {
                    long maskTop = (long)spriteHeight - heightLeft;
                    int maskRight = spriteWidth - widthLeft;
                    FluidContainerUtil.drawTextureWithMasking(matrix, x2, y2, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + 16.0f, zLevel).setUv(uMin, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).setUv(uMax, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).setUv(uMax, vMin);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + (float)maskTop, zLevel).setUv(uMin, vMin);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

