/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.container;

import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.AbstractContainer;
import cy.jdkdigital.generatorgalore.common.container.ManualItemHandler;
import cy.jdkdigital.generatorgalore.common.container.ManualSlotItemHandler;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class GeneratorMenu
extends AbstractContainer {
    public final GeneratorBlockEntity blockEntity;
    public static final int SLOT_FUEL = 0;
    public static final int SLOT_CHARGE = 1;

    public GeneratorMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, GeneratorMenu.getTileEntity(playerInventory, data));
    }

    public GeneratorMenu(int id, Inventory inventory, final GeneratorBlockEntity blockEntity) {
        super(blockEntity.generator.getMenuType().get(), id);
        ManualItemHandler manualItemHandler;
        this.blockEntity = blockEntity;
        this.addDataSlots(new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> blockEntity.litTime;
                    case 1 -> blockEntity.litDuration;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        blockEntity.litTime = value;
                        break;
                    }
                    case 1: {
                        blockEntity.litDuration = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (blockEntity.energyHandler.getEnergyStored() > 0) {
                    blockEntity.energyHandler.extractEnergy(blockEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    blockEntity.energyHandler.receiveEnergy(value, false, true);
                }
            }
        });
        if (this.blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
            this.addDataSlots(new ContainerData(){

                public int get(int i) {
                    return i == 0 ? blockEntity.fluidId : blockEntity.fluidInventory.getFluidInTank(0).getAmount();
                }

                public void set(int i, int value) {
                    switch (i) {
                        case 0: {
                            blockEntity.fluidId = value;
                        }
                        case 1: {
                            FluidStack fluid = blockEntity.fluidInventory.getFluidInTank(0);
                            if (fluid.isEmpty()) {
                                blockEntity.fluidInventory.fill(new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(blockEntity.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                                break;
                            }
                            fluid.setAmount(value);
                        }
                    }
                }

                public int getCount() {
                    return 2;
                }
            });
        }
        if ((manualItemHandler = blockEntity.inventoryHandler) instanceof ManualItemHandler) {
            ManualItemHandler itemHandler = manualItemHandler;
            this.addSlot((Slot)new ManualSlotItemHandler(itemHandler, 0, 80, 54));
            if (blockEntity.generator.hasChargeSlot()) {
                this.addSlot((Slot)new ManualSlotItemHandler(itemHandler, 1, 152, 54));
            }
        }
        this.layoutPlayerInventorySlots(inventory, 0, 8, 84);
    }

    private static GeneratorBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof GeneratorBlockEntity) {
            return (GeneratorBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(Player player) {
        return this.blockEntity != null && player.distanceToSqr((double)this.blockEntity.getBlockPos().getX() + 0.5, (double)this.blockEntity.getBlockPos().getY() + 0.5, (double)this.blockEntity.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    public int getLitProgress() {
        int i = this.blockEntity.litDuration;
        if (i == 0) {
            i = 200;
        }
        return this.blockEntity.litTime * 13 / i;
    }
}

