/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.test;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.machines.blockentities.GeneratorMachineBlockEntity;
import aztech.modern_industrialization.test.framework.MIGameTest;
import aztech.modern_industrialization.test.framework.MIGameTestHelper;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;

public class GeneratorTests {
    @MIGameTest
    public void testGeneratorEmptiesEuBuffer(MIGameTestHelper helper) {
        BlockPos generatorPos = new BlockPos(0, 1, 0);
        Block lvDieselGeneratorBlock = (Block)BuiltInRegistries.BLOCK.getOptional(MI.id("lv_diesel_generator")).orElseThrow();
        helper.setBlock(generatorPos, lvDieselGeneratorBlock);
        GeneratorMachineBlockEntity dieselGenerator = (GeneratorMachineBlockEntity)helper.getBlockEntity(generatorPos);
        try (Transaction tx = Transaction.openRoot();){
            long inserted = dieselGenerator.getInventory().fluidStorage.insert(MIFluids.BIODIESEL.variant(), 1L, (TransactionContext)tx);
            helper.assertValueEqual(inserted, 1L, "inserted biodiesel");
            tx.commit();
        }
        helper.startSequence().thenIdle(3).thenExecute(() -> helper.assertEnergy(generatorPos, 192L, Direction.NORTH)).thenIdle(1).thenExecute(() -> helper.assertEnergy(generatorPos, 250L, Direction.NORTH)).thenSucceed();
    }
}

