/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.item.ItemNetworkData;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;

public class PipeItem
extends Item {
    public final PipeNetworkType type;
    public final PipeNetworkData defaultData;

    public PipeItem(Item.Properties settings, PipeNetworkType type, PipeNetworkData defaultData) {
        super(settings);
        this.type = type;
        this.defaultData = defaultData;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos placingPos = this.tryPlace(context);
        if (placingPos != null) {
            Level world = context.getLevel();
            Player player = context.getPlayer();
            world.blockUpdated(placingPos, Blocks.AIR);
            ItemStack placementStack = context.getItemInHand();
            if (player != null && !player.getAbilities().instabuild) {
                placementStack.shrink(1);
            }
            BlockState newState = world.getBlockState(placingPos);
            SoundType group = newState.getSoundType();
            world.playSound(player, placingPos, group.getPlaceSound(), SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 2.0f, group.getPitch() * 0.8f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        placingPos = context.getClickedPos().relative(context.getClickedFace());
        Level world = context.getLevel();
        BlockEntity entity = world.getBlockEntity(placingPos);
        if (entity instanceof PipeBlockEntity) {
            PipeBlockEntity pipeEntity = (PipeBlockEntity)entity;
            if (pipeEntity.connections.containsKey(this.type)) {
                if (!world.isClientSide) {
                    pipeEntity.addConnection(context.getPlayer(), this.type, context.getClickedFace().getOpposite());
                }
                world.blockUpdated(placingPos, Blocks.AIR);
                BlockState newState = world.getBlockState(placingPos);
                SoundType group = newState.getSoundType();
                world.playSound(context.getPlayer(), placingPos, group.getPlaceSound(), SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 2.0f, group.getPitch() * 0.8f);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return super.useOn(context);
    }

    private BlockPos tryPlace(UseOnContext context) {
        BlockPos hitPos = context.getClickedPos();
        BlockPos adjacentPos = hitPos.relative(context.getClickedFace());
        if (this.tryPlaceAt(context, hitPos)) {
            return hitPos;
        }
        if (this.tryPlaceAt(context, adjacentPos)) {
            return adjacentPos;
        }
        return null;
    }

    private boolean tryPlaceAt(UseOnContext context, BlockPos pos) {
        PipeBlockEntity pipeBe;
        Level world = context.getLevel();
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof PipeBlockEntity && (pipeBe = (PipeBlockEntity)be).canAddPipe(this.type)) {
            if (!world.isClientSide()) {
                pipeBe.addPipe(this.type, this.defaultData.clone());
            }
            return true;
        }
        if (PipeItem.canPlace(context, pos)) {
            boolean waterLog = context.getLevel().getFluidState(pos).getType() == Fluids.WATER;
            world.setBlock(pos, (BlockState)MIPipes.BLOCK_PIPE.get().defaultBlockState().setValue((Property)PipeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterLog)), 3);
            if (!world.isClientSide()) {
                PipeBlockEntity pipeBe2 = (PipeBlockEntity)world.getBlockEntity(pos);
                pipeBe2.addPipe(this.type, this.defaultData.clone());
            }
            return true;
        }
        return false;
    }

    private static boolean canPlace(UseOnContext ctx, BlockPos pos) {
        BlockState state = MIPipes.BLOCK_PIPE.get().defaultBlockState();
        CollisionContext shapeContext = ctx.getPlayer() == null ? CollisionContext.empty() : CollisionContext.of((Entity)ctx.getPlayer());
        return ctx.getLevel().getBlockState(pos).canBeReplaced(new BlockPlaceContext(ctx)) && state.canSurvive((LevelReader)ctx.getLevel(), pos) && ctx.getLevel().isUnobstructed(state, pos, shapeContext);
    }

    public boolean isItemPipe() {
        return this.defaultData instanceof ItemNetworkData;
    }

    public boolean isFluidPipe() {
        return this.defaultData instanceof FluidNetworkData;
    }

    public boolean isCable() {
        return this.defaultData instanceof ElectricityNetworkData;
    }
}

