/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.IPipeMenuProvider;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.util.MobSpawning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty CAMOUFLAGED = BooleanProperty.create((String)"camouflaged");

    public PipeBlock(BlockBehaviour.Properties settings) {
        super(settings.isValidSpawn(MobSpawning.NO_SPAWN).isRedstoneConductor((state, level, pos) -> (Boolean)state.getValue((Property)CAMOUFLAGED)).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CAMOUFLAGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{WATERLOGGED, CAMOUFLAGED}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(pos);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)CAMOUFLAGED) == false && super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return (Boolean)state.getValue((Property)CAMOUFLAGED) == false && super.placeLiquid(level, pos, state, fluidState);
    }

    private static boolean isPartHit(VoxelShape shape, BlockHitResult hit) {
        BlockPos pos = hit.getBlockPos();
        Vec3 posInBlock = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        for (AABB box : shape.toAabbs()) {
            Vec3 dir;
            if (!box.contains(posInBlock.add(dir = box.getCenter().subtract(posInBlock).normalize().scale(1.0E-4)))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PipeVoxelShape getHitPart(Level level, BlockPos pos, BlockHitResult hit) {
        PipeVoxelShape pipeVoxelShape;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            pipeVoxelShape = PipeBlock.getHitPart(pipe, hit);
        } else {
            pipeVoxelShape = null;
        }
        return pipeVoxelShape;
    }

    @Nullable
    private static PipeVoxelShape getHitPart(PipeBlockEntity pipe, BlockHitResult hit) {
        for (PipeVoxelShape partShape : pipe.getPartShapes()) {
            if (!PipeBlock.isPartHit(partShape.shape, hit)) continue;
            return partShape;
        }
        return null;
    }

    static boolean useWrench(PipeBlockEntity pipe, Player player, InteractionHand hand, BlockHitResult hit) {
        if (pipe.hasCamouflage()) {
            if (player.isShiftKeyDown()) {
                return pipe.tryRemoveCamouflage(player, hand);
            }
            return false;
        }
        PipeVoxelShape partShape = PipeBlock.getHitPart(pipe, hit);
        if (partShape == null) {
            return false;
        }
        SoundType group = pipe.getBlockState().getSoundType();
        BlockPos blockPos = pipe.getBlockPos();
        Level world = pipe.getLevel();
        Vec3 hitPos = hit.getLocation();
        if (player != null && player.isShiftKeyDown()) {
            boolean removeBlock;
            boolean bl = removeBlock = pipe.connections.size() == 1;
            if (!world.isClientSide) {
                pipe.removePipeAndDropContainedItems(partShape.type);
            }
            if (removeBlock) {
                world.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
            }
            world.blockUpdated(blockPos, Blocks.AIR);
            world.addFreshEntity((Entity)new ItemEntity(world, hitPos.x, hitPos.y, hitPos.z, new ItemStack((ItemLike)MIPipes.INSTANCE.getPipeItem(partShape.type))));
            world.playSound(player, blockPos, group.getBreakSound(), SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 2.0f, group.getPitch() * 0.8f);
        } else {
            SoundEvent sound = null;
            if (partShape.direction == null) {
                if (!world.isClientSide) {
                    pipe.addConnection(player, partShape.type, hit.getDirection());
                } else {
                    sound = group.getPlaceSound();
                }
            } else if (!world.isClientSide) {
                pipe.removeConnection(partShape.type, partShape.direction);
            } else {
                sound = group.getBreakSound();
            }
            world.blockUpdated(blockPos, Blocks.AIR);
            if (sound != null) {
                world.playSound(player, blockPos, sound, SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 4.0f, group.getPitch() * 0.8f);
            }
        }
        return true;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hit) {
        PipeBlockEntity pipeEntity = (PipeBlockEntity)world.getBlockEntity(blockPos);
        if (pipeEntity.tryApplyCamouflage(player, hand)) {
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        PipeVoxelShape partShape = PipeBlock.getHitPart(pipeEntity, hit);
        if (partShape == null || !partShape.opensGui || pipeEntity.hasCamouflage()) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (!(world.isClientSide || pipeEntity.customUse(partShape, player, hand) || player.isShiftKeyDown())) {
            IPipeMenuProvider menuOpener = pipeEntity.getGui(partShape.type, partShape.direction);
            ((ServerPlayer)player).openMenu((MenuProvider)menuOpener, menuOpener::writeAdditionalData);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        PipeBlockEntity pipeEntity = (PipeBlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        ArrayList<ItemStack> droppedStacks = new ArrayList<ItemStack>();
        for (PipeNetworkNode node : pipeEntity.getNodes()) {
            droppedStacks.add(new ItemStack((ItemLike)MIPipes.INSTANCE.getPipeItem(node.getType())));
            node.appendDroppedStacks(droppedStacks);
        }
        if (pipeEntity.hasCamouflage()) {
            droppedStacks.add(pipeEntity.getCamouflageStack());
        }
        return droppedStacks;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!world.isClientSide) {
            ((PipeBlockEntity)world.getBlockEntity(pos)).updateConnections();
        }
        super.neighborChanged(state, world, pos, block, fromPos, notify);
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)CAMOUFLAGED) != false ? world.getMaxLightLevel() : 0;
    }

    public boolean hasDynamicShape() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof PipeBlockEntity)) {
            return PipeBlockEntity.DEFAULT_SHAPE;
        }
        PipeBlockEntity entity = (PipeBlockEntity)be;
        return entity.currentCollisionShape;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)CAMOUFLAGED) != false ? Shapes.block() : Shapes.empty();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof PipeBlockEntity) {
                PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
                pipe.stateReplaced = true;
            }
            world.removeBlockEntity(pos);
        }
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter renderView, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        if (renderView instanceof ServerLevel) {
            BlockEntity blockEntity = renderView.getBlockEntity(pos);
            if (blockEntity instanceof PipeBlockEntity) {
                PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
                return Objects.requireNonNullElse(pipe.camouflage, state);
            }
        } else {
            PipeBlockEntity.RenderAttachment data = (PipeBlockEntity.RenderAttachment)renderView.getModelData(pos).get(PipeBlockEntity.RenderAttachment.KEY);
            if (data != null) {
                return Objects.requireNonNullElse(data.camouflage(), state);
            }
        }
        return state;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (target instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)target;
            BlockEntity blockEntity = player.level().getBlockEntity(bhr.getBlockPos());
            if (blockEntity instanceof PipeBlockEntity) {
                PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
                if (pipe.hasCamouflage()) {
                    return pipe.getCamouflageStack();
                }
                PipeVoxelShape targetedPart = PipeBlock.getHitPart(player.level(), bhr.getBlockPos(), bhr);
                return new ItemStack((ItemLike)(targetedPart == null ? Items.AIR : MIPipes.INSTANCE.getPipeItem(targetedPart.type)));
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return !MIPipes.transparentCamouflage && (Boolean)state.getValue((Property)CAMOUFLAGED) != false;
    }
}

