/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.config.MIStartupConfig;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeColorProvider;
import aztech.modern_industrialization.pipes.impl.PipeMeshCache;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.common.NeoForge;

public class MIPipesClient {
    private static final PipeRenderer.Factory ITEM_RENDERER = MIPipesClient.makeRenderer(Arrays.asList("item", "item_item", "item_in", "item_in_out", "item_out"), false);
    private static final PipeRenderer.Factory FLUID_RENDERER = MIPipesClient.makeRenderer(Arrays.asList("fluid", "fluid_item", "fluid_in", "fluid_in_out", "fluid_out"), true);
    private static final PipeRenderer.Factory ELECTRICITY_RENDERER = MIPipesClient.makeRenderer(Arrays.asList("electricity", "electricity_blocks"), false);
    public static final Collection<PipeRenderer.Factory> RENDERERS = new LinkedHashSet<PipeRenderer.Factory>();

    public static void setupClient(IEventBus modBus) {
        modBus.addListener(RegisterColorHandlersEvent.Block.class, event -> event.register((BlockColor)new PipeColorProvider(), new Block[]{MIPipes.BLOCK_PIPE.get()}));
        MIPipesClient.registerRenderers();
        NeoForge.EVENT_BUS.addListener(RenderHighlightEvent.Block.class, event -> {
            PipeVoxelShape shape;
            PipeBlockEntity pipe;
            ClientLevel level = Minecraft.getInstance().level;
            BlockPos pos = event.getTarget().getBlockPos();
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof PipeBlockEntity && !(pipe = (PipeBlockEntity)patt0$temp).hasCamouflage() && (shape = PipeBlock.getHitPart((Level)level, pos, event.getTarget())) != null) {
                Vec3 camPos = event.getCamera().getPosition();
                RenderHelper.renderVoxelShape(event.getPoseStack(), event.getMultiBufferSource().getBuffer(RenderType.lines()), shape.shape, (double)pos.getX() - camPos.x(), (double)pos.getY() - camPos.y(), (double)pos.getZ() - camPos.z(), 0.0f, 0.0f, 0.0f, 0.4f);
                event.setCanceled(true);
            }
        });
        NeoForge.EVENT_BUS.addListener(InputEvent.MouseScrollingEvent.class, event -> {
            LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
            if (player.isShiftKeyDown() && MIItem.CONFIG_CARD.is(player.getItemInHand(InteractionHand.MAIN_HAND))) {
                MIPipes.transparentCamouflage = !MIPipes.transparentCamouflage;
                Minecraft.getInstance().levelRenderer.allChanged();
                MIText miText = MIPipes.transparentCamouflage ? MIText.TransparentCamouflageEnabled : MIText.TransparentCamouflageDisabled;
                player.displayClientMessage((Component)miText.text(), true);
                event.setCanceled(true);
            }
        });
    }

    private static PipeRenderer.Factory makeRenderer(final List<String> sprites, final boolean innerQuads) {
        return new PipeRenderer.Factory(){

            @Override
            public Collection<Material> getSpriteDependencies() {
                return sprites.stream().map(n -> new Material(InventoryMenu.BLOCK_ATLAS, MI.id("block/pipes/" + n))).collect(Collectors.toList());
            }

            @Override
            public PipeRenderer create(Function<Material, TextureAtlasSprite> textureGetter) {
                Material[] ids = (Material[])sprites.stream().map(n -> new Material(InventoryMenu.BLOCK_ATLAS, MI.id("block/pipes/" + n))).toArray(Material[]::new);
                return new PipeMeshCache(textureGetter, ids, innerQuads);
            }
        };
    }

    private static void registerRenderers() {
        for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
            if (type.getIdentifier().getPath().endsWith("item_pipe")) {
                PipeRenderer.register(type, ITEM_RENDERER);
                continue;
            }
            if (type.getIdentifier().getPath().endsWith("fluid_pipe")) {
                PipeRenderer.register(type, FLUID_RENDERER);
                continue;
            }
            if (!type.getIdentifier().getPath().endsWith("cable")) continue;
            PipeRenderer.register(type, ELECTRICITY_RENDERER);
        }
        if (MIStartupConfig.INSTANCE.loadAe2Compat()) {
            try {
                Class.forName("aztech.modern_industrialization.compat.ae2.MIAEAddonClient").getMethod("registerPipeRenderers", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        for (PipeNetworkType value : PipeNetworkType.getTypes().values()) {
            RENDERERS.add(PipeRenderer.get(value));
        }
    }
}

