/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.datagen.dynreg.DynamicRegistryDatagen;
import aztech.modern_industrialization.datagen.loot.MIBlockLoot;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.set.MaterialOreSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class OrePart
implements PartKeyProvider {
    public static final ResourceLocation TYPE_STONE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stone");
    public static final ResourceLocation TYPE_DEEPSLATE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"deepslate");
    private final ResourceLocation stoneType;
    private final Block stoneBlock;
    private final PartKey key;

    @Override
    public PartKey key() {
        return this.key;
    }

    public PartTemplate of(UniformInt xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set, TagKey<Biome> biomeTag) {
        return this.of(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel, biomeTag));
    }

    public PartTemplate of(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(UniformInt.of((int)0, (int)2), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public PartTemplate of(UniformInt xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public PartTemplate of(UniformInt xpProvider, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set));
    }

    public PartTemplate of(MaterialOreSet set) {
        return this.of(new OrePartParams(UniformInt.of((int)0, (int)0), set));
    }

    public OrePart(ResourceLocation stoneType) {
        this.stoneType = stoneType;
        this.key = stoneType.equals((Object)TYPE_STONE) ? new PartKey("ore") : new PartKey("ore_%s".formatted(stoneType.getPath()));
        this.stoneBlock = (Block)BuiltInRegistries.BLOCK.getOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)stoneType));
    }

    public PartTemplate of(OrePartParams oreParams) {
        Object displayName;
        if (this.stoneType.equals((Object)TYPE_STONE)) {
            displayName = "%s Ore";
        } else {
            String stoneName = StringUtils.capitalize((String)this.stoneType.getPath().replace('-', ' ').replace('_', ' '));
            displayName = stoneName + " %s Ore";
        }
        return new PartTemplate((String)displayName, this.key).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            String loot;
            PartKey mainPartKey = partContext.get(MaterialProperty.MAIN_PART).key();
            if (mainPartKey.equals(MIParts.INGOT.key())) {
                loot = partContext.getMaterialPart(MIParts.RAW_METAL).getItemId();
            } else if (mainPartKey.equals(MIParts.DUST.key())) {
                loot = partContext.getMaterialPart(MIParts.DUST).getItemId();
            } else if (mainPartKey.equals(MIParts.GEM.key())) {
                loot = partContext.getMaterialPart(MIParts.GEM).getItemId();
            } else {
                throw new UnsupportedOperationException("Could not find matching main part.");
            }
            BlockDefinition<OreBlock> oreBlockBlockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.stoneBlock)).withBlockConstructor(s -> new OreBlock((BlockBehaviour.Properties)s, oreParams, partContext.getMaterialName())).withLoot(new MIBlockLoot.Ore(loot)).sortOrder(SortOrder.ORES.and((Comparable)((Object)partContext.getMaterialName()))).destroyTime(this.stoneBlock.defaultDestroyTime() + 1.5f).requiresCorrectToolForDrops());
            if (mainPartKey.equals(MIParts.INGOT.key()) != (oreParams.xpDropped.getMaxValue() == 0)) {
                throw new IllegalArgumentException("Mismatch between raw ore and xp drops for material: " + partContext.getMaterialName());
            }
            String tag = "c:ores/" + partContext.getMaterialName();
            TagsToGenerate.generateTag(tag, oreBlockBlockDefinition, partContext.getMaterialEnglishName() + " Ores");
            TagsToGenerate.addTagToTag(tag, Tags.Items.ORES.location().toString(), "Ores");
            if (this.stoneType.equals((Object)TYPE_DEEPSLATE)) {
                TagsToGenerate.generateTagNoTranslation((TagKey<Item>)Tags.Items.ORES_IN_GROUND_DEEPSLATE, oreBlockBlockDefinition);
            } else if (this.stoneType.equals((Object)TYPE_STONE)) {
                TagsToGenerate.generateTagNoTranslation((TagKey<Item>)Tags.Items.ORES_IN_GROUND_STONE, oreBlockBlockDefinition);
            }
            if (oreParams.generate) {
                String genIdPrefix = this.stoneType.equals((Object)TYPE_STONE) ? "" : "%s_".formatted(this.stoneType.getPath());
                ResourceLocation oreGenId = MI.id(genIdPrefix + "ore_generator_" + partContext.getMaterialName());
                ResourceKey featureKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)oreGenId);
                ResourceKey placedFeatureKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)oreGenId);
                ResourceKey modifierKey = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)oreGenId);
                DynamicRegistryDatagen.addAction(() -> {
                    Object ruleTest = this.stoneType.equals((Object)TYPE_STONE) ? new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES) : (this.stoneType.equals((Object)TYPE_DEEPSLATE) ? new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES) : new BlockMatchTest(this.stoneBlock));
                    List<OreConfiguration.TargetBlockState> target = List.of(OreConfiguration.target((RuleTest)ruleTest, (BlockState)((OreBlock)((Object)((Object)((Object)oreBlockBlockDefinition.asBlock())))).defaultBlockState()));
                    DynamicRegistryDatagen.add(Registries.CONFIGURED_FEATURE, context -> FeatureUtils.register((BootstrapContext)context, (ResourceKey)featureKey, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(target, oreParams.veinSize)));
                    DynamicRegistryDatagen.add(Registries.PLACED_FEATURE, context -> {
                        Holder.Reference holder = context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(featureKey);
                        List placement = OrePlacements.commonOrePlacement((int)oreParams.veinsPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)oreParams.maxYLevel)));
                        PlacementUtils.register((BootstrapContext)context, (ResourceKey)placedFeatureKey, (Holder)holder, (List)placement);
                    });
                    DynamicRegistryDatagen.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
                        BiomeModifiers.AddFeaturesBiomeModifier modifier = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.lookup(Registries.BIOME).getOrThrow(oreParams.biomeTag), (HolderSet)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(placedFeatureKey)}), GenerationStep.Decoration.UNDERGROUND_ORES);
                        context.register(modifierKey, (Object)modifier);
                    });
                });
            }
        }).withTexture(new TextureGenParams.Ore(this.stoneType, oreParams.set)).withCustomPath((this.stoneType.equals((Object)TYPE_STONE) ? "" : "%s_".formatted(this.stoneType.getPath())) + "%s_ore", "ores/%s");
    }

    public static List<PartTemplate> ofAll(OrePartParams params) {
        return List.of(new OrePart(TYPE_DEEPSLATE).of(params), new OrePart(TYPE_STONE).of(params));
    }

    public static List<PartTemplate> ofAll(UniformInt xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return OrePart.ofAll(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public static List<PartTemplate> ofAll(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return OrePart.ofAll(new OrePartParams(UniformInt.of((int)0, (int)0), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public static class OrePartParams {
        public final UniformInt xpDropped;
        public final MaterialOreSet set;
        public final boolean generate;
        public final TagKey<Biome> biomeTag;
        public final int veinsPerChunk;
        public final int veinSize;
        public final int maxYLevel;

        private OrePartParams(UniformInt xpDropped, MaterialOreSet set, boolean generate, int veinsPerChunk, int veinSize, int maxYLevel, TagKey<Biome> biomeTag) {
            this.xpDropped = xpDropped;
            this.set = set;
            this.generate = generate;
            this.biomeTag = biomeTag;
            this.veinsPerChunk = veinsPerChunk;
            this.veinSize = veinSize;
            this.maxYLevel = maxYLevel;
        }

        public OrePartParams(UniformInt xpDropped, MaterialOreSet set) {
            this(xpDropped, set, false, 0, 0, 0, (TagKey<Biome>)BiomeTags.IS_OVERWORLD);
        }

        public OrePartParams(UniformInt xpDropped, MaterialOreSet set, int veinsPerChunk, int veinSize, int maxYLevel) {
            this(xpDropped, set, true, veinsPerChunk, veinSize, maxYLevel, (TagKey<Biome>)BiomeTags.IS_OVERWORLD);
        }

        public OrePartParams(UniformInt xpDropped, MaterialOreSet set, int veinsPerChunk, int veinSize, int maxYLevel, TagKey<Biome> biomeTag) {
            this(xpDropped, set, true, veinsPerChunk, veinSize, maxYLevel, biomeTag);
        }
    }
}

