/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.ShapeValidComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class MultiblockMachineBlockEntity
extends MachineBlockEntity {
    @Nullable
    private ShapeMatcher shapeMatcher;
    public final ShapeValidComponent shapeValid = new ShapeValidComponent();

    public MultiblockMachineBlockEntity(BEP bep, MachineGuiParameters guiParams, OrientationComponent.Params orientationParams) {
        super(bep, guiParams, orientationParams);
        this.registerComponents(this.shapeValid);
    }

    public boolean isShapeValid() {
        return this.shapeValid.shapeValid;
    }

    public ShapeMatcher createShapeMatcher() {
        return new ShapeMatcher(this.level, this.worldPosition, this.orientation.facingDirection, this.getActiveShape());
    }

    protected void onRematch(ShapeMatcher shapeMatcher) {
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = this.createShapeMatcher();
            this.shapeMatcher.registerListeners(this.level);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.shapeValid.shapeValid = false;
            this.shapeMatcher.rematch(this.level);
            this.onRematch(this.shapeMatcher);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.shapeValid.shapeValid = true;
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    public final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.level);
            this.shapeMatcher = null;
        }
    }

    @Override
    public boolean useWrench(Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (super.useWrench(player, hand, hitResult)) {
            if (!this.level.isClientSide) {
                this.unlink();
            }
            return true;
        }
        return false;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide) {
            this.unlink();
        }
    }

    public abstract ShapeTemplate getActiveShape();

    public ShapeTemplate getBigShape() {
        return this.getActiveShape();
    }

    public OrientationComponent getOrientation() {
        return this.orientation;
    }
}

