/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.models;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.part.MIParts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class MachineCasings {
    public static final Map<ResourceLocation, MachineCasing> registeredCasings = new HashMap<ResourceLocation, MachineCasing>();
    public static final List<CasingName> translations = new ArrayList<CasingName>();
    public static final MachineCasing BRICKED_BRONZE = MachineCasings.create(MI.id("bricked_bronze"), "Bricked Bronze");
    public static final MachineCasing BRICKED_STEEL = MachineCasings.create(MI.id("bricked_steel"), "Bricked Steel");
    public static final MachineCasing BRICKS = MachineCasings.createBlockImitation(MI.id("bricks"), () -> Blocks.BRICKS);
    public static final MachineCasing BRONZE = MachineCasings.createBlockImitation(MI.id("bronze"), () -> MIMaterials.BRONZE.getPart(MIParts.MACHINE_CASING).asBlock());
    public static final MachineCasing BRONZE_PLATED_BRICKS = MachineCasings.createBlockImitation(MI.id("bronze_plated_bricks"), () -> MIMaterials.BRONZE.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
    public static final MachineCasing CLEAN_STAINLESS_STEEL = MachineCasings.createBlockImitation(MI.id("clean_stainless_steel_machine_casing"), () -> MIMaterials.STAINLESS_STEEL.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
    public static final MachineCasing CONFIGURABLE_TANK = MachineCasings.create(MI.id("configurable_tank"), "Configurable Tank");
    public static final MachineCasing STAINLESS_STEEL_PIPE = MachineCasings.createBlockImitation(MI.id("stainless_steel_machine_casing_pipe"), () -> MIMaterials.STAINLESS_STEEL.getPart(MIParts.MACHINE_CASING_PIPE).asBlock());
    public static final MachineCasing FIREBRICKS = MachineCasings.createBlockImitation(MI.id("firebricks"), () -> MIBlock.BLOCK_FIRE_CLAY_BRICKS.asBlock());
    public static final MachineCasing FROSTPROOF = MachineCasings.createBlockImitation(MI.id("frostproof_machine_casing"), () -> MIMaterials.ALUMINUM.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
    public static final MachineCasing HEATPROOF = MachineCasings.createBlockImitation(MI.id("heatproof_machine_casing"), () -> MIMaterials.INVAR.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
    public static final MachineCasing STEEL = MachineCasings.createBlockImitation(MI.id("steel"), () -> MIMaterials.STEEL.getPart(MIParts.MACHINE_CASING).asBlock());
    public static final MachineCasing STEEL_CRATE = MachineCasings.create(MI.id("steel_crate"), "Steel Crate");
    public static final MachineCasing TITANIUM = MachineCasings.createBlockImitation(MI.id("titanium"), () -> MIMaterials.TITANIUM.getPart(MIParts.MACHINE_CASING).asBlock());
    public static final MachineCasing TITANIUM_PIPE = MachineCasings.createBlockImitation(MI.id("titanium_machine_casing_pipe"), () -> MIMaterials.TITANIUM.getPart(MIParts.MACHINE_CASING_PIPE).asBlock());
    public static final MachineCasing SOLID_TITANIUM = MachineCasings.createBlockImitation(MI.id("solid_titanium_machine_casing"), () -> MIMaterials.TITANIUM.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
    public static final MachineCasing NUCLEAR = MachineCasings.createBlockImitation(MI.id("nuclear_casing"), () -> MIMaterials.NUCLEAR_ALLOY.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
    public static final MachineCasing PLASMA_HANDLING_IRIDIUM = MachineCasings.createBlockImitation(MI.id("plasma_handling_iridium_machine_casing"), () -> MIMaterials.IRIDIUM.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());

    public static MachineCasing createBlockImitation(ResourceLocation key, Supplier<? extends Block> block) {
        Objects.requireNonNull(block);
        return MachineCasings.register(key, block);
    }

    public static MachineCasing create(ResourceLocation key, String englishName) {
        Objects.requireNonNull(englishName);
        MachineCasing casing = MachineCasings.register(key, null);
        translations.add(new CasingName(casing, englishName));
        return casing;
    }

    private static MachineCasing register(ResourceLocation key, @Nullable Supplier<? extends Block> blockImitation) {
        if (registeredCasings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate machine casing definition: " + String.valueOf(key));
        }
        MachineCasing casing = new MachineCasing(key, blockImitation);
        registeredCasings.put(key, casing);
        return casing;
    }

    public static MachineCasing get(ResourceLocation key) {
        MachineCasing casing = registeredCasings.get(key);
        if (casing != null) {
            return casing;
        }
        throw new IllegalArgumentException("Machine casing model \"" + String.valueOf(key) + "\" does not exist.");
    }

    public static MachineCasing get(String name) {
        return MachineCasings.get(ResourceLocation.isValidPath((String)name) ? MI.id(name) : ResourceLocation.parse((String)name));
    }

    static {
        KubeJSProxy.instance.fireRegisterMachineCasingsEvent();
    }

    public record CasingName(MachineCasing casing, String englishName) {
    }
}

