/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.util.RenderHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RecipeEfficiencyBarClient
implements GuiComponentClient {
    final RecipeEfficiencyBar.Parameters params;
    boolean hasActiveRecipe;
    int efficiencyTicks;
    int maxEfficiencyTicks;
    long currentRecipeEu;
    long baseRecipeEu;
    long maxRecipeEu;
    private static final ResourceLocation TEXTURE = MI.id("textures/gui/efficiency_bar.png");
    private static final int WIDTH = 100;
    private static final int HEIGHT = 2;

    public RecipeEfficiencyBarClient(RegistryFriendlyByteBuf buf) {
        this.params = new RecipeEfficiencyBar.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.hasActiveRecipe = buf.readBoolean();
        if (this.hasActiveRecipe) {
            this.efficiencyTicks = buf.readInt();
            this.maxEfficiencyTicks = buf.readInt();
            this.currentRecipeEu = buf.readLong();
            this.baseRecipeEu = buf.readLong();
        }
        this.maxRecipeEu = buf.readLong();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    implements ClientComponentRenderer {
        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            guiGraphics.blit(TEXTURE, x + RecipeEfficiencyBarClient.this.params.renderX - 1, y + RecipeEfficiencyBarClient.this.params.renderY - 1, 0.0f, 2.0f, 102, 4, 102, 6);
            if (RecipeEfficiencyBarClient.this.hasActiveRecipe) {
                int barPixels = (int)((float)RecipeEfficiencyBarClient.this.efficiencyTicks / (float)RecipeEfficiencyBarClient.this.maxEfficiencyTicks * 100.0f);
                guiGraphics.blit(TEXTURE, x + RecipeEfficiencyBarClient.this.params.renderX, y + RecipeEfficiencyBarClient.this.params.renderY, 0.0f, 0.0f, barPixels, 2, 102, 6);
            }
        }

        @Override
        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(RecipeEfficiencyBarClient.this.params.renderX, RecipeEfficiencyBarClient.this.params.renderY, 100, 2, cursorX - x, cursorY - y)) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                if (RecipeEfficiencyBarClient.this.hasActiveRecipe) {
                    DecimalFormat factorFormat = new DecimalFormat("#.#");
                    tooltip.add(MIText.EfficiencyTicks.text(RecipeEfficiencyBarClient.this.efficiencyTicks, RecipeEfficiencyBarClient.this.maxEfficiencyTicks));
                    tooltip.add(MIText.EfficiencyFactor.text(factorFormat.format((double)RecipeEfficiencyBarClient.this.currentRecipeEu / (double)RecipeEfficiencyBarClient.this.baseRecipeEu)));
                    tooltip.add(MIText.EfficiencyEu.text(RecipeEfficiencyBarClient.this.currentRecipeEu));
                } else {
                    tooltip.add(MIText.EfficiencyDefaultMessage.text());
                }
                tooltip.add(MIText.EfficiencyMaxOverclock.text(RecipeEfficiencyBarClient.this.maxRecipeEu));
                guiGraphics.renderTooltip(font, tooltip, Optional.empty(), cursorX, cursorY);
            }
        }
    }
}

