/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.network.machines.SetAutoExtractPacket;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;

public class AutoExtractClient
implements GuiComponentClient {
    final boolean displayAsInsert;
    final boolean hasExtractItems;
    final boolean hasExtractFluids;
    boolean[] extractStatus = new boolean[2];

    public AutoExtractClient(RegistryFriendlyByteBuf buf) {
        this.displayAsInsert = buf.readBoolean();
        this.hasExtractItems = buf.readBoolean();
        this.hasExtractFluids = buf.readBoolean();
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.extractStatus[0] = buf.readBoolean();
        this.extractStatus[1] = buf.readBoolean();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    private class Renderer
    implements ClientComponentRenderer {
        private Renderer() {
        }

        @Override
        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            if (AutoExtractClient.this.hasExtractFluids) {
                this.addExtractButton(container, false);
            }
            if (AutoExtractClient.this.hasExtractItems) {
                this.addExtractButton(container, true);
            }
        }

        private void addExtractButton(ClientComponentRenderer.ButtonContainer container, boolean isItem) {
            int u = isItem ? 20 : 0;
            String type = isItem ? "item" : "fluid";
            int index = isItem ? 0 : 1;
            String insertOrExtract = AutoExtractClient.this.displayAsInsert ? "insert" : "extract";
            container.addButton(u, syncId -> {
                boolean newExtract;
                AutoExtractClient.this.extractStatus[index] = newExtract = !AutoExtractClient.this.extractStatus[index];
                new SetAutoExtractPacket((int)syncId, isItem, newExtract).sendToServer();
            }, () -> {
                ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
                if (AutoExtractClient.this.extractStatus[index]) {
                    MutableComponent component = isItem ? (AutoExtractClient.this.displayAsInsert ? MIText.ItemAutoInsertOn.text() : MIText.ItemAutoExtractOn.text()) : (AutoExtractClient.this.displayAsInsert ? MIText.FluidAutoInsertOn.text() : MIText.FluidAutoExtractOn.text());
                    lines.add(component);
                    lines.add(MIText.ClickToDisable.text().setStyle(TextHelper.GRAY_TEXT));
                } else {
                    MutableComponent component = isItem ? (AutoExtractClient.this.displayAsInsert ? MIText.ItemAutoInsertOff.text() : MIText.ItemAutoExtractOff.text()) : (AutoExtractClient.this.displayAsInsert ? MIText.FluidAutoInsertOff.text() : MIText.FluidAutoExtractOff.text());
                    lines.add(component);
                    lines.add(MIText.ClickToEnable.text().setStyle(TextHelper.GRAY_TEXT));
                }
                return lines;
            }, () -> AutoExtractClient.this.extractStatus[index]);
        }

        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
        }
    }
}

