/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.items.ActivatableItem;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.items.SteamDrillFuel;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.GeometryHelper;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.Nullable;

public class SteamDrillItem
extends Item
implements DynamicToolItem,
ItemContainingItemHelper,
ActivatableItem {
    public static final StorageBehaviour<ItemVariant> DRILL_BEHAVIOUR = new StorageBehaviour<ItemVariant>(){

        @Override
        public long getCapacityForResource(ItemVariant resource) {
            return resource.getMaxStackSize();
        }

        @Override
        public boolean canInsert(ItemVariant item) {
            int burnTicks = item.toStack().getBurnTime(null);
            return burnTicks > 0;
        }
    };
    private static final int FULL_WATER = 18000;
    @Nullable
    private static List<ItemStack> totalDrops = null;
    private static final WeakHashMap<Player, ClickedBlock> lastClickedBlock = new WeakHashMap();
    private static final ThreadLocal<Boolean> recursiveMineBlock;

    public SteamDrillItem(Item.Properties settings) {
        super(settings.stacksTo(1).rarity(Rarity.UNCOMMON).component(MIComponents.SILK_TOUCH, (Object)true).component(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY).component(MIComponents.WATER, (Object)0));
    }

    private static boolean isNotSilkTouch(ItemStack stack) {
        return (Boolean)stack.getOrDefault(MIComponents.SILK_TOUCH, (Object)true) == false;
    }

    private static void setSilkTouch(ItemStack stack, boolean silkTouch) {
        stack.set(MIComponents.SILK_TOUCH, (Object)silkTouch);
    }

    @Override
    public boolean getDefaultActivatedState() {
        return true;
    }

    private boolean should3by3(ItemStack stack, Player player) {
        return this.isActivated(stack) && !player.isShiftKeyDown();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.is((Item)this) || slotChanged;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is((Item)this) || !this.canUse(newStack) || CommonProxy.INSTANCE.shouldSteamDrillForceBreakReset();
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.isSupportedBlock(stack, state) && this.canUse(stack) && !state.is(Tiers.NETHERITE.getIncorrectBlocksForDrops())) {
            return true;
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.canUse(stack)) {
            if (this.isCorrectToolForDrops(stack, state)) {
                float speed = 4.0f;
                Player player = CommonProxy.INSTANCE.findUser(stack);
                if (player != null && !this.should3by3(stack, player)) {
                    speed *= 4.0f;
                }
                return speed;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        if (this.canUse(stack)) {
            return ItemHelper.getToolModifiers(5.0);
        }
        return ItemAttributeModifiers.EMPTY;
    }

    @Nullable
    public Area getArea(BlockGetter level, Player player, ItemStack stack, boolean rayTraceOnly) {
        ClickedBlock clickedBlock;
        if (!this.should3by3(stack, player)) {
            return null;
        }
        if (!rayTraceOnly && (clickedBlock = lastClickedBlock.get(player)) != null) {
            return SteamDrillItem.getArea(clickedBlock.pos(), clickedBlock.face());
        }
        HitResult rayTraceResult = SteamDrillItem.rayTraceSimple(level, player, 0.0f);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)rayTraceResult;
            Direction facing = blockResult.getDirection();
            return SteamDrillItem.getArea(blockResult.getBlockPos(), facing);
        }
        return null;
    }

    private static Area getArea(BlockPos pos, Direction hitFace) {
        int face = hitFace.get3DDataValue();
        Vec3 right = GeometryHelper.FACE_RIGHT[face];
        int rx = (int)right.x();
        int ry = (int)right.y();
        int rz = (int)right.z();
        Vec3 up = GeometryHelper.FACE_UP[face];
        int ux = (int)up.x();
        int uy = (int)up.y();
        int uz = (int)up.z();
        return new Area(pos, pos.offset(rx + ux, ry + uy, rz + uz), pos.offset(-rx - ux, -ry - uy, -rz - uz));
    }

    private static boolean isAreaMineableBlock(BlockGetter level, BlockState state, BlockPos pos) {
        return !state.isAir() && (state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(BlockTags.MINEABLE_WITH_SHOVEL)) && state.getDestroySpeed(level, pos) > 0.0f;
    }

    public static void forEachMineableBlock(BlockGetter world, Area area, LivingEntity miner, BiConsumer<BlockPos, BlockState> callback) {
        if (!(miner instanceof Player)) {
            return;
        }
        BlockState centerState = world.getBlockState(area.center());
        if (!SteamDrillItem.isAreaMineableBlock(world, centerState, area.center())) {
            return;
        }
        callback.accept(area.center(), centerState);
        BlockPos.betweenClosed((BlockPos)area.corner1(), (BlockPos)area.corner2()).forEach(blockPos -> {
            if (world.getBlockEntity(blockPos) != null || area.center().equals(blockPos)) {
                return;
            }
            BlockState tempState = world.getBlockState(blockPos);
            if (SteamDrillItem.isAreaMineableBlock(world, tempState, blockPos)) {
                callback.accept((BlockPos)blockPos, tempState);
            }
        });
    }

    private static HitResult rayTraceSimple(BlockGetter world, Player living, float partialTicks) {
        double blockReachDistance = living.blockInteractionRange();
        Vec3 vec3d = living.getEyePosition(partialTicks);
        Vec3 vec3d1 = living.getViewVector(partialTicks);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * blockReachDistance, vec3d1.y * blockReachDistance, vec3d1.z * blockReachDistance);
        return world.clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)living));
    }

    private static void mergeDrops(BlockDropsEvent event) {
        if (totalDrops == null) {
            return;
        }
        block0: for (ItemEntity entity : event.getDrops()) {
            if (entity.getItem().isEmpty()) continue;
            for (ItemStack drop : totalDrops) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)entity.getItem(), (ItemStack)drop)) continue;
                drop.grow(entity.getItem().getCount());
                continue block0;
            }
            totalDrops.add(entity.getItem());
        }
        event.getDrops().clear();
    }

    private static void trackClickedFace(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            PlayerInteractEvent.LeftClickBlock.Action action = event.getAction();
            if (action == PlayerInteractEvent.LeftClickBlock.Action.START || action == PlayerInteractEvent.LeftClickBlock.Action.STOP) {
                lastClickedBlock.put(player, new ClickedBlock(event.getPos().immutable(), event.getFace()));
            } else if (action == PlayerInteractEvent.LeftClickBlock.Action.ABORT) {
                lastClickedBlock.remove(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        this.useFuel(stack, miner);
        if (!(miner instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer p = (ServerPlayer)miner;
        if (recursiveMineBlock.get().booleanValue()) {
            return false;
        }
        Area area = this.getArea((BlockGetter)world, (Player)p, stack, false);
        if (area == null) {
            return false;
        }
        lastClickedBlock.remove(p);
        totalDrops = new ArrayList<ItemStack>();
        recursiveMineBlock.set(true);
        try {
            SteamDrillItem.forEachMineableBlock((BlockGetter)world, area, miner, (blockPos, tempState) -> p.gameMode.destroyBlock(blockPos));
        }
        finally {
            recursiveMineBlock.set(false);
        }
        totalDrops.forEach(itemStack -> {
            ItemEntity itemEntity = new ItemEntity(world, p.getX(), p.getY(), p.getZ(), itemStack);
            itemEntity.setNoPickUpDelay();
            ItemEntityPickupEvent.Pre pickupEvent = new ItemEntityPickupEvent.Pre((Player)p, itemEntity);
            NeoForge.EVENT_BUS.post((Event)pickupEvent);
            if (!itemEntity.isRemoved()) {
                ItemHandlerHelper.giveItemToPlayer((Player)p, (ItemStack)itemEntity.getItem());
            }
        });
        totalDrops = null;
        world.getEntitiesOfClass(ExperienceOrb.class, new AABB(Vec3.atLowerCornerOf((Vec3i)area.corner1()), Vec3.atLowerCornerOf((Vec3i)area.corner2())).inflate(1.0)).forEach(entityXPOrb -> entityXPOrb.teleportTo((double)miner.blockPosition().getX(), (double)miner.blockPosition().getY(), (double)miner.blockPosition().getZ()));
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useFuel(stack, attacker);
        return true;
    }

    private void useFuel(ItemStack stack, @Nullable LivingEntity entity) {
        if ((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) > 0 && ((SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY)).burnTicks() == 0) {
            int burnTicks = this.consumeFuel(stack, Simulation.ACT);
            stack.set(MIComponents.STEAM_DRILL_FUEL, (Object)new SteamDrillFuel(burnTicks, burnTicks));
            if (burnTicks > 0 && entity != null) {
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            ItemStack stack = user.getItemInHand(hand);
            SteamDrillItem.setSilkTouch(stack, SteamDrillItem.isNotSilkTouch(stack));
            if (!world.isClientSide) {
                user.displayClientMessage((Component)(SteamDrillItem.isNotSilkTouch(stack) ? MIText.ToolSwitchedNoSilkTouch.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult hitResult = SteamDrillItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        FluidState fluidState = world.getFluidState(hitResult.getBlockPos());
        if (fluidState.getType() == Fluids.WATER || fluidState.getType() == Fluids.FLOWING_WATER) {
            this.fillWater(user, itemStack);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
        }
        return super.use(world, user, hand);
    }

    private void fillWater(Player player, ItemStack stack) {
        if ((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) != 18000) {
            stack.set(MIComponents.WATER, (Object)18000);
            player.playNotifySound(SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        SteamDrillFuel fuel = (SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY);
        if (fuel.burnTicks() > 0) {
            stack.set(MIComponents.STEAM_DRILL_FUEL, (Object)new SteamDrillFuel(Math.max(0, fuel.burnTicks() - 5), fuel.maxBurnTicks()));
            stack.update(MIComponents.WATER, (Object)0, w -> Math.max(0, w - 5));
        }
        if (fuel.burnTicks() == 0) {
            stack.set(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY);
        }
        if ((Integer)stack.getOrDefault(MIComponents.WATER.get(), (Object)0) == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize() && !this.tryFillWater(player, stack, inv.getItem(i)); ++i) {
            }
        }
    }

    public boolean canUse(ItemStack stack) {
        if ((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) == 0) {
            return false;
        }
        return ((SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY)).burnTicks() > 0 || this.consumeFuel(stack, Simulation.SIMULATE) > 0;
    }

    private int consumeFuel(ItemStack stack, Simulation simulation) {
        int burnTicks = ((ItemVariant)this.getResource(stack)).toStack().getBurnTime(null);
        if (burnTicks > 0) {
            if (simulation.isActing()) {
                ItemStack burnt = ((ItemVariant)this.getResource(stack)).toStack();
                this.setAmount(stack, this.getAmount(stack) - 1L);
                if (burnt.hasCraftingRemainingItem()) {
                    new ContainerItem.ItemHandler(stack, this).insertItem(0, burnt.getCraftingRemainingItem(), false, true, true);
                }
            }
            return burnTicks;
        }
        return 0;
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.getAllEnchantments(stack, (HolderLookup.RegistryLookup<Enchantment>)enchantment.unwrapLookup()).getLevel(enchantment);
    }

    public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        if (!SteamDrillItem.isNotSilkTouch(stack)) {
            lookup.get(Enchantments.SILK_TOUCH).ifPresent(h -> map.set((Holder)h, 1));
        }
        return map.toImmutable();
    }

    public boolean isFoil(ItemStack pStack) {
        return !SteamDrillItem.isNotSilkTouch(pStack);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        SteamDrillFuel fuel = (SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY);
        return Optional.of(new SteamDrillTooltipData((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) * 100 / 18000, fuel.burnTicks(), Math.max(1, fuel.maxBurnTicks()), (ItemVariant)this.getResource(stack), this.getAmount(stack)));
    }

    public boolean overrideStackedOnOther(ItemStack stackBarrel, Slot slot, ClickAction clickType, Player player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stackBarrel, ItemStack itemStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return this.handleOtherStackedOnMe(stackBarrel, itemStack, slot, clickType, player, cursorStackReference);
    }

    @Override
    public boolean handleClick(Player player, ItemStack barrelLike, Mutable<ItemStack> otherStack) {
        if (this.tryFillWater(player, barrelLike, (ItemStack)otherStack.getValue())) {
            return true;
        }
        return ItemContainingItemHelper.super.handleClick(player, barrelLike, otherStack);
    }

    private boolean tryFillWater(Player player, ItemStack barrelLike, ItemStack fillSource) {
        IFluidHandlerItem otherStorage = (IFluidHandlerItem)fillSource.getCapability(Capabilities.FluidHandler.ITEM);
        if (otherStorage != null) {
            long totalWater = 0L;
            for (int tank = 0; tank < otherStorage.getTanks(); ++tank) {
                if (otherStorage.getFluidInTank(tank).getFluid() != Fluids.WATER) continue;
                totalWater += (long)otherStorage.getFluidInTank(tank).getAmount();
            }
            if (totalWater * (long)fillSource.getCount() >= 1000L) {
                this.fillWater(player, barrelLike);
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        SteamDrillTooltipData data = (SteamDrillTooltipData)this.getTooltipImage(stack).get();
        tooltip.add((Component)MIText.WaterPercent.text(data.waterLevel).setStyle(TextHelper.WATER_TEXT));
        int barWater = (int)Math.ceil((double)data.waterLevel / 5.0);
        int barVoid = 20 - barWater;
        tooltip.add((Component)Component.literal((String)"|".repeat(barWater)).setStyle(TextHelper.WATER_TEXT).append((Component)Component.literal((String)"|".repeat(barVoid)).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x6B6B6B)))));
        if (data.burnTicks > 0) {
            tooltip.add((Component)MIText.SecondsLeft.text(data.burnTicks / 100).setStyle(TextHelper.GRAY_TEXT));
        }
        tooltip.add((Component)MIText.MiningArea.text((this.isActivated(stack) ? MIText.MiningArea3x3 : MIText.MiningArea1x1).text().setStyle(TextHelper.NUMBER_TEXT)).setStyle(TextHelper.GRAY_TEXT.withItalic(Boolean.valueOf(false))));
        tooltip.add((Component)MIText.SilkTouchState.text(SteamDrillItem.isNotSilkTouch(stack) ? MIText.Deactivated.text().setStyle(TextHelper.RED) : MIText.Activated.text().setStyle(TextHelper.GREEN)).setStyle(TextHelper.GRAY_TEXT.withItalic(Boolean.valueOf(false))));
    }

    @Override
    public StorageBehaviour<ItemVariant> getBehaviour() {
        return DRILL_BEHAVIOUR;
    }

    static {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, SteamDrillItem::mergeDrops);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, SteamDrillItem::trackClickedFace);
        recursiveMineBlock = ThreadLocal.withInitial(() -> false);
    }

    private record ClickedBlock(BlockPos pos, Direction face) {
    }

    public record Area(BlockPos center, BlockPos corner1, BlockPos corner2) {
    }

    public record SteamDrillTooltipData(int waterLevel, int burnTicks, int maxBurnTicks, ItemVariant variant, long amount) implements TooltipComponent
    {
    }
}

