/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.inventory.SlotConfig;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.TransferHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class MIInventory
implements IComponent {
    public static final MIInventory EMPTY = new MIInventory(Collections.emptyList(), Collections.emptyList(), SlotPositions.empty(), SlotPositions.empty());
    private BlockCapabilityCache<IItemHandler, @Nullable Direction> outputCache;
    public final MIItemStorage itemStorage;
    public final MIFluidStorage fluidStorage;
    public final SlotPositions itemPositions;
    public final SlotPositions fluidPositions;

    public MIInventory(List<ConfigurableItemStack> itemStacks, List<ConfigurableFluidStack> fluidStacks, SlotPositions itemPositions, SlotPositions fluidPositions) {
        this.itemStorage = new MIItemStorage(new ArrayList<ConfigurableItemStack>(itemStacks));
        this.fluidStorage = new MIFluidStorage(new ArrayList<ConfigurableFluidStack>(fluidStacks));
        this.itemPositions = itemPositions;
        this.fluidPositions = fluidPositions;
        if (itemPositions.size() != itemStacks.size()) {
            throw new IllegalArgumentException("Mismatched item slots and positions. Slot count: " + itemStacks.size() + ", position count: " + itemPositions.size());
        }
        if (fluidPositions.size() != fluidStacks.size()) {
            throw new IllegalArgumentException("Mismatched fluid slots and positions. Slot count: " + fluidStacks.size() + ", position count: " + fluidPositions.size());
        }
    }

    public void addListener(ChangeListener listener, Object token) {
        listener.listenAll(this.getItemStacks(), token);
        listener.listenAll(this.getFluidStacks(), token);
    }

    public List<ConfigurableItemStack> getItemStacks() {
        return this.itemStorage.stacks;
    }

    public List<ConfigurableFluidStack> getFluidStacks() {
        return this.fluidStorage.stacks;
    }

    public void autoExtractItems(Level world, BlockPos pos, Direction direction) {
        IItemHandler target;
        boolean updateCache;
        boolean bl = updateCache = this.outputCache == null || this.outputCache.context() != direction.getOpposite();
        if (updateCache) {
            this.outputCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)world), (BlockPos)pos.relative(direction), (Object)direction.getOpposite());
        }
        if ((target = (IItemHandler)this.outputCache.getCapability()) != null) {
            TransferHelper.moveAll(this.itemStorage.itemHandler, target, true);
        }
    }

    public void autoExtractFluids(Level world, BlockPos pos, Direction direction) {
        IFluidHandler target = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
        if (target != null) {
            TransferHelper.tryFluidTransfer(target, this.fluidStorage.fluidHandler, Integer.MAX_VALUE, true);
        }
    }

    public void autoInsertItems(Level world, BlockPos pos, Direction direction) {
        IItemHandler target = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
        if (target != null) {
            TransferHelper.moveAll(target, this.itemStorage.itemHandler, false);
        }
    }

    public void autoInsertFluids(Level world, BlockPos pos, Direction direction) {
        IFluidHandler target = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
        if (target != null) {
            TransferHelper.tryFluidTransfer(this.fluidStorage.fluidHandler, target, Integer.MAX_VALUE, true);
        }
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        NbtHelper.putList(tag, "items", this.itemStorage.stacks, configurableItemStack -> configurableItemStack.toNbt(registries));
        NbtHelper.putList(tag, "fluids", this.fluidStorage.stacks, configurableFluidStack -> configurableFluidStack.toNbt(registries));
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        ArrayList newItemStacks = new ArrayList();
        ArrayList newFluidStacks = new ArrayList();
        NbtHelper.getList(tag, "items", newItemStacks, t -> new ConfigurableItemStack((CompoundTag)t, registries));
        NbtHelper.getList(tag, "fluids", newFluidStacks, t -> new ConfigurableFluidStack((CompoundTag)t, registries));
        if (isUpgradingMachine) {
            for (int i = 0; i < newFluidStacks.size() && i < this.fluidStorage.stacks.size(); ++i) {
                ((ConfigurableFluidStack)newFluidStacks.get(i)).setCapacity(((ConfigurableFluidStack)this.fluidStorage.stacks.get(i)).getCapacity());
            }
        }
        SlotConfig.readSlotList(this.itemStorage.stacks, newItemStacks);
        SlotConfig.readSlotList(this.fluidStorage.stacks, newFluidStacks);
    }
}

