/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MultiblockCategory
extends ViewerCategory<Recipe> {
    private static final int COLUMNS = 6;
    private static final int ROWS = 2;

    protected MultiblockCategory() {
        super(Recipe.class, MI.id("multiblock_shapes"), (Component)MIText.MultiblockMaterials.text(), MIItem.WRENCH.stack(), 142, 64);
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
    }

    @Override
    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<Recipe> consumer) {
        for (ReiMachineRecipes.MultiblockShape entry : ReiMachineRecipes.multiblockShapes) {
            consumer.accept(new Recipe(entry.machine(), entry.shapeTemplate(), entry.alternative()));
        }
    }

    @Override
    public void buildLayout(Recipe recipe, ViewerCategory.LayoutBuilder builder) {
        builder.invisibleInput(recipe.controller);
        builder.outputSlot(this.width / 2 - 8, 5).item(recipe.controller);
        builder.scrollableSlots(6, 2, recipe.materials);
    }

    @Override
    public void buildWidgets(Recipe recipe, ViewerCategory.WidgetList widgets) {
        widgets.scrollableSlots(6, 2, recipe.materials);
    }

    @Override
    public ResourceLocation getRecipeId(Recipe recipe) {
        return recipe.id;
    }

    protected static class Recipe {
        public final ItemStack controller;
        public final List<ItemStack> materials = new ArrayList<ItemStack>();
        public final ResourceLocation id;

        public Recipe(ResourceLocation controller, ShapeTemplate shapeTemplate, @Nullable String alternative) {
            this.controller = ((Item)BuiltInRegistries.ITEM.get(controller)).getDefaultInstance();
            TreeMap<Item, Integer> materials = new TreeMap<Item, Integer>(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)));
            for (Map.Entry<BlockPos, SimpleMember> entry : shapeTemplate.simpleMembers.entrySet()) {
                BlockState state = entry.getValue().getPreviewState();
                Item item = state.getBlock().asItem();
                if (item == Items.AIR) continue;
                materials.put(item, 1 + materials.getOrDefault(item, 0));
            }
            for (Map.Entry<Object, SimpleMember> entry : materials.entrySet()) {
                this.materials.add(new ItemStack((ItemLike)entry.getKey(), ((Integer)((Object)entry.getValue())).intValue()));
            }
            this.id = ResourceLocation.fromNamespaceAndPath((String)controller.getNamespace(), (String)("/" + controller.getPath() + "/" + materials.size() + (String)(alternative == null ? "" : "/" + alternative)));
        }
    }
}

