/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.compat.viewer.impl.ViewerUtil;
import aztech.modern_industrialization.compat.viewer.impl.jei.DrawableIcon;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IScrollGridWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

class ViewerCategoryJei<D>
extends AbstractRecipeCategory<D> {
    private final IJeiHelpers helpers;
    public final ViewerCategory<D> wrapped;
    public final RecipeType<D> recipeType;
    private final IDrawable fluidSlot;

    public ViewerCategoryJei(IJeiHelpers helpers, ViewerCategory<D> wrapped) {
        super(RecipeType.create((String)wrapped.id.getNamespace(), (String)wrapped.id.getPath(), wrapped.dataClass), wrapped.title, DrawableIcon.create(helpers.getGuiHelper(), wrapped.icon), wrapped.width - 8, wrapped.height - 8);
        this.helpers = helpers;
        this.wrapped = wrapped;
        this.recipeType = RecipeType.create((String)wrapped.id.getNamespace(), (String)wrapped.id.getPath(), wrapped.dataClass);
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.fluidSlot = guiHelper.createDrawable(MachineScreen.SLOT_ATLAS, 18, 0, 18, 18);
    }

    public void setRecipe(final IRecipeLayoutBuilder builder, D recipe, IFocusGroup focuses) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                return this.slot(RecipeIngredientRole.INPUT, x, y);
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                return this.slot(RecipeIngredientRole.OUTPUT, x, y);
            }

            @Override
            public void invisibleInput(ItemStack stack) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(stack);
            }

            @Override
            public void invisibleOutput(ItemStack stack) {
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(stack);
            }

            @Override
            public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
                for (ItemStack stack : stacks) {
                    builder.addInputSlot().addItemStack(stack);
                }
            }

            private ViewerCategory.SlotBuilder slot(RecipeIngredientRole role, int x, int y) {
                final IRecipeSlotBuilder slotBuilder = builder.addSlot(role, x - 4, y - 4).setStandardSlotBackground();
                return new ViewerCategory.SlotBuilder(){

                    @Override
                    public ViewerCategory.SlotBuilder variant(TransferVariant<?> variant) {
                        if (variant instanceof ItemVariant) {
                            ItemVariant item = (ItemVariant)variant;
                            this.item(item.toStack());
                        } else if (variant instanceof FluidVariant) {
                            FluidVariant fluid = (FluidVariant)variant;
                            if (!fluid.isBlank()) {
                                slotBuilder.addFluidStack(fluid.getFluid(), 1000L, fluid.getComponentsPatch());
                            }
                            slotBuilder.setBackground(ViewerCategoryJei.this.fluidSlot, -1, -1);
                        } else {
                            throw new IllegalArgumentException("Unknown variant type: " + String.valueOf(variant.getClass()));
                        }
                        return this;
                    }

                    private static void addProbability(IRecipeSlotBuilder slot, float probability) {
                        slot.addRichTooltipCallback((recipeSlotView, tooltip) -> {
                            boolean input = recipeSlotView.getRole() == RecipeIngredientRole.INPUT;
                            Component probabilityLine = ViewerUtil.getProbabilityTooltip(probability, input);
                            if (probabilityLine != null) {
                                tooltip.add((FormattedText)probabilityLine);
                            }
                        });
                    }

                    @Override
                    public ViewerCategory.SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
                        slotBuilder.addFluidStack(fluid.getFluid(), amount, fluid.getComponentsPatch());
                        slotBuilder.setFluidRenderer(1L, false, 16, 16);
                        1.addProbability(slotBuilder, probability);
                        slotBuilder.setBackground(ViewerCategoryJei.this.fluidSlot, -1, -1);
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder fluid(FluidIngredient ingredient, long amount, float probability) {
                        for (FluidStack fs : ingredient.getStacks()) {
                            slotBuilder.addFluidStack(fs.getFluid(), amount, fs.getComponentsPatch());
                        }
                        slotBuilder.setFluidRenderer(1L, false, 16, 16);
                        1.addProbability(slotBuilder, probability);
                        slotBuilder.setBackground(ViewerCategoryJei.this.fluidSlot, -1, -1);
                        return this;
                    }

                    private ViewerCategory.SlotBuilder items(List<ItemStack> stacks, float probability) {
                        slotBuilder.addItemStacks(stacks);
                        1.addProbability(slotBuilder, probability);
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder item(ItemStack stack, float probability) {
                        return this.items(List.of(stack), probability);
                    }

                    @Override
                    public ViewerCategory.SlotBuilder ingredient(Ingredient ingredient, long amount, float probability) {
                        return this.items(Stream.of(ingredient.getItems()).map(i -> {
                            ItemStack cp = i.copy();
                            cp.setCount((int)amount);
                            return cp;
                        }).toList(), probability);
                    }

                    @Override
                    public ViewerCategory.SlotBuilder removeBackground() {
                        slotBuilder.setBackground((IDrawable)ViewerCategoryJei.this.helpers.getGuiHelper().createBlankDrawable(0, 0), 0, 0);
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder markCatalyst() {
                        return this;
                    }
                };
            }
        });
    }

    public void createRecipeExtras(final IRecipeExtrasBuilder builder, D recipe, IFocusGroup focuses) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                return new ViewerCategory.SlotBuilder.NoOp();
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                return new ViewerCategory.SlotBuilder.NoOp();
            }

            @Override
            public void invisibleInput(ItemStack stack) {
            }

            @Override
            public void invisibleOutput(ItemStack stack) {
            }

            @Override
            public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
                List slots = builder.getRecipeSlots().getSlots(RecipeIngredientRole.INPUT);
                IScrollGridWidget scrollWidget = builder.addScrollGridWidget(slots, cols, rows);
                scrollWidget.setPosition(0, 0, ViewerCategoryJei.this.getWidth(), ViewerCategoryJei.this.getHeight(), HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
            }
        });
    }

    public void draw(D recipe, IRecipeSlotsView recipeSlotsView, final GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(-4.0f, -4.0f, 0.0f);
        this.wrapped.buildWidgets(recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(Component text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable Component tooltip) {
                Font font = Minecraft.getInstance().font;
                int width = font.width((FormattedText)text);
                float alignedX = switch (align) {
                    default -> throw new MatchException(null, null);
                    case ViewerCategory.TextAlign.LEFT -> x;
                    case ViewerCategory.TextAlign.CENTER -> x - (float)width / 2.0f;
                    case ViewerCategory.TextAlign.RIGHT -> x - (float)width;
                };
                guiGraphics.drawString(font, text, (int)alignedX, (int)y, overrideColor ? -12566464 : -1, shadow);
            }

            @Override
            public void arrow(int x, int y) {
                this.texture(MI.id("textures/gui/jei/arrow.png"), x, y, 0, 17, 24, 17);
            }

            @Override
            public void texture(ResourceLocation loc, int x, int y, int u, int v, int width, int height) {
                IDrawableStatic drawable = ViewerCategoryJei.this.helpers.getGuiHelper().createDrawable(loc, u, v, width, height);
                drawable.draw(guiGraphics, x, y);
            }

            @Override
            public void drawable(Consumer<GuiGraphics> widget) {
                widget.accept(guiGraphics);
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<Component> tooltip) {
            }

            @Override
            public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
            }
        });
        guiGraphics.pose().popPose();
    }

    public void getTooltip(final ITooltipBuilder tooltips, D recipe, IRecipeSlotsView recipeSlotsView, double jeiMouseX, double jeiMouseY) {
        final double mouseX = jeiMouseX + 4.0;
        final double mouseY = jeiMouseY + 4.0;
        this.wrapped.buildWidgets(recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(Component text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable Component tooltip) {
                if (tooltip != null) {
                    Font font = Minecraft.getInstance().font;
                    if ((double)x <= mouseX && (double)y <= mouseY && mouseX <= (double)(x + (float)font.width((FormattedText)text))) {
                        Objects.requireNonNull(font);
                        if (mouseY <= (double)(y + 9.0f)) {
                            tooltips.add((FormattedText)tooltip);
                        }
                    }
                }
            }

            @Override
            public void arrow(int x, int y) {
            }

            @Override
            public void texture(ResourceLocation loc, int x, int y, int u, int v, int width, int height) {
            }

            @Override
            public void drawable(Consumer<GuiGraphics> widget) {
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<Component> tooltip) {
                if ((double)x <= mouseX && (double)y <= mouseY && mouseX <= (double)(x + w) && mouseY <= (double)(y + h)) {
                    tooltips.addAll(tooltip);
                }
            }

            @Override
            public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
            }
        });
    }

    public ResourceLocation getRegistryName(D recipe) {
        return this.wrapped.getRecipeId(recipe);
    }
}

