/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record SideQualifier(List<Side> sides) implements ASTNode
{
    public static final SideQualifier NULL = new SideQualifier(List.of(Side.NULL));
    public static final SideQualifier ALL = new SideQualifier(List.of(Side.TOP, Side.BOTTOM, Side.NORTH, Side.SOUTH, Side.EAST, Side.WEST, Side.NULL));
    public static final SideQualifier DEFAULT = NULL;

    @Nullable
    public Direction getNonNullDirection(BlockState blockState) {
        for (Side side : this.sides) {
            if (side == Side.NULL) continue;
            return side.resolve(blockState);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SideQualifier)) {
            return false;
        }
        SideQualifier that = (SideQualifier)o;
        return Objects.equals(this.sides, that.sides);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.sides);
    }

    public ArrayList<@Nullable Direction> resolve(BlockState blockState) {
        ArrayList<@Nullable Direction> rtn = new ArrayList<Direction>(7);
        for (Side side : this.sides) {
            rtn.add(side.resolve(blockState));
        }
        return rtn;
    }
}

