/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;

public class SFMComponentUtils {
    public static MutableComponent substring(Component component, int start, int end) {
        MutableComponent rtn = Component.empty();
        AtomicInteger seen = new AtomicInteger(0);
        component.visit((style, content) -> {
            int contentEnd;
            int contentStart = Math.max(start - seen.get(), 0);
            if (contentStart < (contentEnd = Math.min(end - seen.get(), content.length()))) {
                rtn.append((Component)Component.literal((String)content.substring(contentStart, contentEnd)).withStyle(style));
            }
            seen.addAndGet(content.length());
            return Optional.empty();
        }, Style.EMPTY);
        return rtn;
    }

    public static int length(Component component) {
        AtomicInteger seen = new AtomicInteger(0);
        component.visit(content -> {
            seen.addAndGet(content.length());
            return Optional.empty();
        });
        return seen.get();
    }

    @MCVersionDependentBehaviour
    public static void appendLore(ItemStack stack, Component ... components) {
        ArrayList newLore = new ArrayList();
        ItemLore existing = (ItemLore)stack.get(DataComponents.LORE);
        if (existing != null) {
            newLore.addAll(existing.lines());
        }
        Collections.addAll(newLore, components);
        stack.set(DataComponents.LORE, (Object)new ItemLore(Collections.unmodifiableList(newLore)));
    }
}

