/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.SlottedPart;
import codechicken.multipart.block.TileMultipart;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class TSlottedTile
extends TileMultipart {
    private MultiPart[] v_partMap = new MultiPart[27];

    public TSlottedTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TSlottedTile) {
            this.v_partMap = ((TSlottedTile)that).v_partMap;
        }
    }

    @Override
    public void clearParts() {
        super.clearParts();
        Arrays.fill(this.v_partMap, null);
    }

    @Override
    public MultiPart getSlottedPart(int slot) {
        return this.v_partMap[slot];
    }

    @Override
    public void partRemoved(MultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof SlottedPart) {
            for (int i = 0; i < this.v_partMap.length; ++i) {
                if (this.v_partMap[i] != part) continue;
                this.v_partMap[i] = null;
            }
        }
    }

    @Override
    public boolean canAddPart(MultiPart part) {
        if (part instanceof SlottedPart) {
            int mask = ((SlottedPart)part).getSlotMask();
            for (int i = 0; i < this.v_partMap.length; ++i) {
                if ((mask & 1 << i) == 0 || this.getSlottedPart(i) == null) continue;
                return false;
            }
        }
        return super.canAddPart(part);
    }

    @Override
    public void bindPart(MultiPart part) {
        super.bindPart(part);
        if (part instanceof SlottedPart) {
            int mask = ((SlottedPart)part).getSlotMask();
            for (int i = 0; i < this.v_partMap.length; ++i) {
                if ((mask & 1 << i) <= 0) continue;
                this.v_partMap[i] = part;
            }
        }
    }
}

