/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.RandomTickPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.minecraft.MinecraftMultipartModContent;
import codechicken.multipart.minecraft.TorchPart;
import codechicken.multipart.util.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class RedstoneTorchPart
extends TorchPart
implements FaceRedstonePart,
RandomTickPart {
    @Nullable
    private BurnoutEntry burnout;

    public RedstoneTorchPart() {
    }

    public RedstoneTorchPart(BlockState state) {
        super(state);
    }

    @Override
    public MultipartType<?> getType() {
        return (MultipartType)MinecraftMultipartModContent.REDSTONE_TORCH_PART.get();
    }

    @Override
    protected Block getStandingBlock() {
        return Blocks.REDSTONE_TORCH;
    }

    @Override
    protected Block getWallBlock() {
        return Blocks.REDSTONE_WALL_TORCH;
    }

    public boolean active() {
        return (Boolean)this.state.getValue((Property)RedstoneTorchBlock.LIT);
    }

    @Override
    public void animateTick(RandomSource random) {
        if (!this.active()) {
            return;
        }
        super.animateTick(random);
    }

    @Override
    public void onNeighborBlockChanged(BlockPos from) {
        if (!this.level().isClientSide && !this.dropIfCantStay() && this.isBeingPowered() == this.active()) {
            this.scheduleTick(2);
        }
    }

    public boolean isBeingPowered() {
        return RedstoneInteractions.getPowerTo(this, this.getSide().ordinal()) > 0;
    }

    @Override
    public void scheduledTick() {
        if (!this.level().isClientSide && this.isBeingPowered() == this.active()) {
            this.toggle();
        }
    }

    @Override
    public void randomTick() {
        this.scheduledTick();
    }

    @Override
    public void onChunkLoad(LevelChunk chunk) {
        TickScheduler.loadRandomTick(this, chunk);
    }

    @Override
    public void onWorldJoin() {
        TickScheduler.loadRandomTick(this);
    }

    private boolean burnedOut(boolean add) {
        BurnoutEntry b;
        long time = this.level().getGameTime();
        while (this.burnout != null && this.burnout.timeout <= time) {
            this.burnout = this.burnout.next;
        }
        if (add) {
            BurnoutEntry e = new BurnoutEntry(this.level().getGameTime() + 60L);
            if (this.burnout == null) {
                this.burnout = e;
            } else {
                b = this.burnout;
                while (b.next != null) {
                    b = b.next;
                }
                b.next = e;
            }
        }
        if (this.burnout == null) {
            return false;
        }
        int i = 0;
        b = this.burnout;
        while (b != null) {
            ++i;
            b = b.next;
        }
        return i >= 8;
    }

    private void toggle() {
        if (this.active()) {
            if (this.burnedOut(true)) {
                this.level().levelEvent(1502, this.pos(), 0);
            }
        } else if (this.burnedOut(false)) {
            return;
        }
        this.state = (BlockState)this.state.setValue((Property)RedstoneTorchBlock.LIT, (Comparable)Boolean.valueOf(!this.active()));
        this.sendUpdate(this::writeDesc);
        this.tile().setChanged();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(1);
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
        this.onNeighborBlockChanged(this.pos());
    }

    @Override
    public int strongPowerLevel(int side) {
        return side == 1 && this.active() ? 15 : 0;
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() && side != this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    public static class BurnoutEntry {
        long timeout;
        @Nullable
        BurnoutEntry next;

        public BurnoutEntry(long l) {
            this.timeout = l;
        }
    }
}

