/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.init;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MultiPartRegistries {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    @Nullable
    private static Registry<MultipartType<?>> MULTIPART_TYPES;
    @Nullable
    private static Registry<PartConverter> PART_CONVERTERS;

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(MultiPartRegistries::createRegistries);
    }

    private static void createRegistries(NewRegistryEvent event) {
        MULTIPART_TYPES = event.create(new RegistryBuilder(MultipartType.MULTIPART_TYPES).sync(true));
        PART_CONVERTERS = event.create(new RegistryBuilder(PartConverter.PART_CONVERTERS).sync(false));
    }

    public static Registry<MultipartType<?>> multipartTypes() {
        return Objects.requireNonNull(MULTIPART_TYPES, "MultipartType registry not created yet.");
    }

    public static Registry<PartConverter> partConverters() {
        return Objects.requireNonNull(PART_CONVERTERS, "PartConverter registry not created yet.");
    }

    public static void writePart(MCDataOutput data, MultiPart part) {
        MultipartType<?> type = Objects.requireNonNull(part.getType());
        ResourceLocation name = Objects.requireNonNull(type.getRegistryName());
        if (!MULTIPART_TYPES.containsKey(name)) {
            throw new RuntimeException("MultiPartType with name '" + String.valueOf(name) + "' is not registered.");
        }
        data.writeRegistryIdDirect(MULTIPART_TYPES, type);
        part.writeDesc(data);
    }

    public static MultiPart readPart(MCDataInput data) {
        MultipartType type = (MultipartType)data.readRegistryIdDirect(MULTIPART_TYPES);
        Object part = type.createPartClient(data);
        part.readDesc(data);
        return part;
    }

    public static CompoundTag savePart(CompoundTag nbt, MultiPart part, HolderLookup.Provider registries) {
        MultipartType<?> type = Objects.requireNonNull(part.getType());
        ResourceLocation name = Objects.requireNonNull(type.getRegistryName());
        nbt.putString("id", name.toString());
        part.save(nbt, registries);
        return nbt;
    }

    @Nullable
    public static MultiPart loadPart(CompoundTag nbt, HolderLookup.Provider registries) {
        ResourceLocation name = ResourceLocation.parse((String)nbt.getString("id"));
        MultipartType type = (MultipartType)MULTIPART_TYPES.get(name);
        if (type == null) {
            logger.error("Missing mapping for MultiPartType with ID: {}", (Object)name);
            return null;
        }
        Object part = type.createPartServer(nbt);
        if (part != null) {
            part.load(nbt, registries);
        }
        return part;
    }

    public static Collection<MultiPart> convertBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        for (PartConverter conv : PART_CONVERTERS) {
            PartConverter.ConversionResult<Collection<MultiPart>> result = conv.convert(level, pos, state);
            if (!result.success()) continue;
            assert (result.result() != null);
            return result.result();
        }
        return List.of();
    }

    @Nullable
    public static MultiPart convertItem(MultipartPlaceContext context) {
        for (PartConverter conv : PART_CONVERTERS) {
            PartConverter.ConversionResult<MultiPart> result = conv.convert(context);
            if (!result.success()) continue;
            assert (result.result() != null);
            return result.result();
        }
        return null;
    }
}

