/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.api;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.particle.CustomBreakingParticle;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.api.MicroMaterialClient;
import codechicken.microblock.client.MicroblockRender;
import codechicken.microblock.part.MicroblockPart;
import codechicken.microblock.util.MaskedCuboid;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockMicroMaterial
extends MicroMaterial {
    public final BlockState state;

    public BlockMicroMaterial(Block block) {
        this(block.defaultBlockState());
    }

    public BlockMicroMaterial(BlockState state) {
        this.state = state;
    }

    @Override
    public boolean isTransparent() {
        return !this.state.canOcclude();
    }

    @Override
    public int getLightEmission() {
        return this.state.getLightEmission();
    }

    @Override
    public float getStrength(Player player) {
        return this.state.getDestroyProgress(player, (BlockGetter)player.level(), new BlockPos(0, -1, 0));
    }

    @Override
    public Component getLocalizedName() {
        return this.getItem().getHoverName();
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)this.state.getBlock(), 1);
    }

    @Override
    public SoundType getSound() {
        return this.state.getSoundType();
    }

    @Override
    public float getExplosionResistance(BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.state.getExplosionResistance(level, pos, explosion);
    }

    @Override
    public void initializeClient(Consumer<MicroMaterialClient> cons) {
        cons.accept(new MicroMaterialClient(){

            @Override
            public RenderType getItemRenderLayer() {
                return ItemBlockRenderTypes.getRenderType((BlockState)BlockMicroMaterial.this.state, (boolean)true);
            }

            @Override
            public List<BakedQuad> getQuads(MicroblockPart part, @Nullable Direction side, @Nullable RenderType layer, Iterable<MaskedCuboid> cuboids) {
                if (side != null) {
                    return List.of();
                }
                return MicroblockRender.getQuads(part, BlockMicroMaterial.this.state, layer, cuboids);
            }

            @Override
            public void renderCuboids(CCRenderState ccrs, @Nullable RenderType layer, Iterable<MaskedCuboid> cuboids) {
                MicroblockRender.renderCuboids(ccrs, BlockMicroMaterial.this.state, layer, cuboids);
            }

            @Override
            public void addHitEffects(MicroblockPart part, PartRayTraceResult hit, ParticleEngine engine) {
                CustomParticleHandler.addBlockHitEffects((Level)part.level(), (Cuboid6)part.getBounds().copy().add(part.pos()), (Direction)hit.getDirection(), (TextureAtlasSprite)this.getSprite(part.level(), part.pos()), (ParticleEngine)engine);
            }

            @Override
            public void addDestroyEffects(MicroblockPart part, PartRayTraceResult hit, ParticleEngine engine) {
                CustomParticleHandler.addBlockDestroyEffects((Level)part.level(), (Cuboid6)part.getBounds().copy().add(part.pos()), List.of(this.getSprite(part.level(), part.pos())), (ParticleEngine)engine);
            }

            @Override
            public void addLandingEffects(MicroblockPart part, PartRayTraceResult hit, Vector3 entity, int numberOfParticles) {
                Level level = part.level();
                ParticleEngine manager = Minecraft.getInstance().particleEngine;
                TextureAtlasSprite sprite = this.getSprite(level, part.pos());
                if (numberOfParticles != 0) {
                    for (int i = 0; i < numberOfParticles; ++i) {
                        double mX = level.random.nextGaussian() * (double)0.15f;
                        double mY = level.random.nextGaussian() * (double)0.15f;
                        double mZ = level.random.nextGaussian() * (double)0.15f;
                        manager.add((Particle)CustomBreakingParticle.newLandingParticle((ClientLevel)((ClientLevel)level), (double)entity.x, (double)entity.y, (double)entity.z, (double)mX, (double)mY, (double)mZ, (TextureAtlasSprite)sprite));
                    }
                }
            }

            @Override
            public void addRunningEffects(MicroblockPart part, PartRayTraceResult hit, Entity entity) {
                Level level = part.level();
                ParticleEngine manager = Minecraft.getInstance().particleEngine;
                TextureAtlasSprite sprite = this.getSprite(level, part.pos());
                double x = entity.getX() + ((double)level.random.nextFloat() - 0.5) * (double)entity.getBbWidth();
                double y = entity.getBoundingBox().minY + 0.1;
                double z = entity.getZ() + ((double)level.random.nextFloat() - 0.5) * (double)entity.getBbWidth();
                manager.add((Particle)new CustomBreakingParticle((ClientLevel)level, x, y, z, -entity.getDeltaMovement().x * 4.0, 1.5, -entity.getDeltaMovement().z * 4.0, sprite));
            }

            private TextureAtlasSprite getSprite(Level level, BlockPos pos) {
                return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getTexture(BlockMicroMaterial.this.state, level, pos);
            }
        });
    }

    public static ResourceLocation makeMaterialKey(BlockState state) {
        Block block = state.getBlock();
        ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)block);
        StringBuilder path = new StringBuilder(blockKey.getPath());
        if (!state.getProperties().isEmpty()) {
            record ValuePair(Property<?> key, Comparable<?> value) {
            }
            path.append("//");
            ArrayList entries = FastStream.of(state.getValues().entrySet()).sorted(Comparator.comparing(e -> ((Property)e.getKey()).getName())).map(e -> new ValuePair((Property)e.getKey(), (Comparable)e.getValue())).toList();
            for (ValuePair entry : entries) {
                Property<?> property = entry.key;
                if (path.charAt(path.length() - 2) != '/') {
                    path.append('/');
                }
                path.append(property.getName()).append('.').append(property.getName((Comparable)SneakyUtils.unsafeCast(entry.value)));
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)blockKey.getNamespace(), (String)path.toString());
    }
}

