/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.payloads;

import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.client.ParticleHandler;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ParticlePayload(int gateId, double x, double y, double z, int color, EffectType effectType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ParticlePayload> TYPE = new CustomPacketPayload.Type(Gateways.loc("particles"));
    public static final StreamCodec<FriendlyByteBuf, ParticlePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ParticlePayload::gateId, (StreamCodec)ByteBufCodecs.DOUBLE, ParticlePayload::x, (StreamCodec)ByteBufCodecs.DOUBLE, ParticlePayload::y, (StreamCodec)ByteBufCodecs.DOUBLE, ParticlePayload::z, (StreamCodec)ByteBufCodecs.INT, ParticlePayload::color, EffectType.STREAM_CODEC, ParticlePayload::effectType, ParticlePayload::new);

    public ParticlePayload(GatewayEntity source, double x, double y, double z, TextColor color, EffectType type) {
        this(source.getId(), x, y, z, color.getValue(), type);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum EffectType {
        IDLE,
        SPAWNED;

        public static final IntFunction<EffectType> BY_ID;
        public static final StreamCodec<ByteBuf, EffectType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])EffectType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static class Provider
    implements PayloadProvider<ParticlePayload> {
        public CustomPacketPayload.Type<ParticlePayload> getType() {
            return TYPE;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ParticlePayload> getCodec() {
            return CODEC;
        }

        public void handle(ParticlePayload msg, IPayloadContext ctx) {
            ParticleHandler.handle(msg);
        }

        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.CLIENTBOUND);
        }

        public String getVersion() {
            return "1";
        }
    }
}

