/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public record StandardWaveEntity(EntityType<?> type, Optional<String> desc, Optional<CompoundTag> tag, List<WaveModifier> modifiers, boolean finalizeSpawn, int count) implements WaveEntity
{
    public static Codec<StandardWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(StandardWaveEntity::type), (App)Codec.STRING.optionalFieldOf("desc").forGetter(StandardWaveEntity::desc), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(StandardWaveEntity::tag), (App)WaveModifier.CODEC.listOf().optionalFieldOf("modifiers", Collections.emptyList()).forGetter(StandardWaveEntity::modifiers), (App)Codec.BOOL.optionalFieldOf("finalize_spawn", (Object)true).forGetter(StandardWaveEntity::finalizeSpawn), (App)Codec.intRange((int)1, (int)256).optionalFieldOf("count", (Object)1).forGetter(StandardWaveEntity::count)).apply((Applicative)inst, StandardWaveEntity::new));

    @Override
    public LivingEntity createEntity(ServerLevel level, GatewayEntity gate) {
        CompoundTag data = this.tag.orElse(new CompoundTag());
        data.putString("id", EntityType.getKey(this.type).toString());
        Entity ent = EntityType.loadEntityRecursive((CompoundTag)data, (Level)level, Function.identity());
        if (ent instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)ent;
            this.modifiers.forEach(m -> m.apply(living, gate));
            return living;
        }
        return null;
    }

    @Override
    public MutableComponent getDescription() {
        String descKey = this.desc.orElse(this.type.getDescriptionId());
        return Component.translatable((String)"tooltip.gateways.with_count", (Object[])new Object[]{this.getCount(), Component.translatable((String)descKey)});
    }

    @Override
    public boolean shouldFinalizeSpawn() {
        return this.finalizeSpawn;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public Codec<? extends WaveEntity> getCodec() {
        return CODEC;
    }

    public static Builder builder(EntityType<?> type) {
        return new Builder(type);
    }

    public static class Builder {
        private final EntityType<?> type;
        private Optional<String> desc = Optional.empty();
        private Optional<CompoundTag> tag = Optional.empty();
        private final List<WaveModifier> modifiers = new ArrayList<WaveModifier>();
        private boolean finalizeSpawn = true;
        private int count = 1;

        public Builder(EntityType<?> type) {
            this.type = type;
        }

        public Builder desc(String desc) {
            this.desc = Optional.of(desc);
            return this;
        }

        public Builder nbt(UnaryOperator<CompoundTag> config) {
            CompoundTag tag = this.tag.orElse(new CompoundTag());
            this.tag = Optional.ofNullable((CompoundTag)config.apply(tag));
            return this;
        }

        public Builder addModifier(WaveModifier modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        public Builder addModifiers(List<WaveModifier> modifiers) {
            this.modifiers.addAll(modifiers);
            return this;
        }

        public Builder finalizeSpawn(boolean finalizeSpawn) {
            this.finalizeSpawn = finalizeSpawn;
            return this;
        }

        public Builder count(int count) {
            if (count < 1 || count > 256) {
                throw new IllegalArgumentException("Entity count must be between 1 and 256");
            }
            this.count = count;
            return this;
        }

        public StandardWaveEntity build() {
            if (this.type == null) {
                throw new IllegalStateException("Entity type must be specified");
            }
            return new StandardWaveEntity(this.type, this.desc, this.tag, Collections.unmodifiableList(new ArrayList<WaveModifier>(this.modifiers)), this.finalizeSpawn, this.count);
        }
    }
}

