/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import dev.shadowsoffire.gateways.client.GatewayParticleData;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.payloads.ParticlePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ParticleHandler {
    public static void handle(ParticlePayload msg) {
        double x = msg.x();
        double y = msg.y();
        double z = msg.z();
        int color = msg.color();
        ParticlePayload.EffectType type = msg.effectType();
        Entity src = Minecraft.getInstance().level.getEntity(msg.gateId());
        if (src == null) {
            return;
        }
        switch (type) {
            case IDLE: {
                GatewayParticleData data = new GatewayParticleData(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
                RandomSource rand = src.level().random;
                for (int i = 0; i < 6; ++i) {
                    double velX = Mth.nextDouble((RandomSource)rand, (double)-0.15, (double)0.15);
                    double velY = Mth.nextDouble((RandomSource)rand, (double)-0.15, (double)0.15);
                    double velZ = Mth.nextDouble((RandomSource)rand, (double)-0.15, (double)0.15);
                    double xOff = Mth.nextDouble((RandomSource)rand, (double)-0.25, (double)0.25);
                    double yOff = Mth.nextDouble((RandomSource)rand, (double)-0.2, (double)0.2);
                    double zOff = Mth.nextDouble((RandomSource)rand, (double)-0.25, (double)0.25);
                    Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)data, x + xOff, y + yOff, z + zOff, velX, velY, velZ);
                }
                break;
            }
            case SPAWNED: {
                GatewayParticleData data = new GatewayParticleData(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
                RandomSource rand = src.level().random;
                for (int i = 0; i < 25; ++i) {
                    double velY = Mth.nextDouble((RandomSource)rand, (double)0.05, (double)0.35);
                    double xOff = Mth.nextDouble((RandomSource)rand, (double)-0.15, (double)0.15);
                    double yOff = Mth.nextDouble((RandomSource)rand, (double)0.05, (double)0.15);
                    double zOff = Mth.nextDouble((RandomSource)rand, (double)-0.15, (double)0.15);
                    Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)data, x + xOff, y + yOff, z + zOff, 0.0, velY, 0.0);
                }
                break;
            }
        }
    }

    public static void spawnIdleParticles(GatewayEntity gate) {
        if (!gate.isValid()) {
            return;
        }
        Level level = gate.level();
        RandomSource rand = level.random;
        int color = gate.getGateway().color().getValue();
        GatewayParticleData data = new GatewayParticleData(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        double x = gate.getX();
        double y = gate.getY() + (double)(gate.getBbHeight() / 2.0f);
        double z = gate.getZ();
        float scale = gate.getGateway().size().getScale();
        for (int i = 0; i < 30; ++i) {
            float deg = (float)((double)(i * 12) * Math.PI / 180.0);
            double velX = (double)Mth.cos((float)deg) * 0.1 * (double)scale;
            double velY = Mth.nextDouble((RandomSource)rand, (double)(-0.2 * (double)scale), (double)-0.15);
            double velZ = (double)Mth.sin((float)deg) * 0.1 * (double)scale;
            double xOff = velX * rand.nextDouble() * 0.2;
            double yOff = Mth.nextDouble((RandomSource)rand, (double)-0.1, (double)0.2);
            double zOff = velZ * rand.nextDouble() * 0.2;
            if (!((double)rand.nextFloat() < 0.35)) continue;
            Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)data, x + xOff, y + yOff, z + zOff, velX, velY, velZ);
        }
    }
}

