/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_caelum.ritual;

import com.hollingsworth.ars_caelum.ArsCaelum;
import com.hollingsworth.ars_caelum.lib.RitualLang;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ElderSummonRitual
extends AbstractRitual {
    protected void tick() {
        WildenChimera.spawnPhaseParticles((BlockPos)this.getPos().above(), (Level)this.getWorld(), (int)1);
        if (this.getWorld().getGameTime() % 20L == 0L) {
            this.incrementProgress();
        }
        if (this.getWorld().getGameTime() % 60L == 0L && !this.getWorld().isClientSide) {
            if (!this.isBossSpawn()) {
                BlockPos summonPos = this.getPos().above().east(this.rand.nextInt(3) - this.rand.nextInt(6)).north(this.rand.nextInt(3) - this.rand.nextInt(6));
                Guardian mobEntity = new Guardian(EntityType.GUARDIAN, this.getWorld());
                this.summon((Mob)mobEntity, summonPos);
                if (this.getProgress() >= 15) {
                    this.setFinished();
                }
            } else if (this.getProgress() >= 8) {
                ElderGuardian chimera = new ElderGuardian(EntityType.ELDER_GUARDIAN, this.getWorld());
                this.summon((Mob)chimera, this.getPos().above());
                this.setFinished();
            }
        }
    }

    public boolean isBossSpawn() {
        return this.didConsumeItem((ItemLike)Items.SEA_LANTERN);
    }

    public void summon(Mob mob, BlockPos pos) {
        mob.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        mob.level().addFreshEntity((Entity)mob);
    }

    public boolean canConsumeItem(ItemStack stack) {
        return super.canConsumeItem(stack) || !this.isBossSpawn() && stack.getItem() == Items.SEA_LANTERN;
    }

    public ResourceLocation getRegistryName() {
        return ArsCaelum.prefix(RitualLang.ELDER_SUMMON);
    }

    public String getLangDescription() {
        return "Summons waves of Guardians. Can be augmented with a Sea Lantern to summon an Elder Guardian.";
    }

    public String getLangName() {
        return "Summon Guardians";
    }
}

