/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.proxy;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.client.hud.FloppyDiskConsumeItemsGuiOverlay;
import net.swedz.little_big_redstone.client.hud.StickyNoteViewContentsGuiOverlay;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteView;
import net.swedz.little_big_redstone.gui.floppydisk.FloppyDiskScreen;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.microchip.MicrochipScreen;
import net.swedz.little_big_redstone.gui.stickynote.edit.StickyNoteEditScreen;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.little_big_redstone.gui.stickynote.view.StickyNoteViewScreen;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.proxy.LBRProxy;
import net.swedz.tesseract.neoforge.proxy.ProxyEntrypoint;
import net.swedz.tesseract.neoforge.proxy.ProxyEnvironment;

@ProxyEntrypoint(environment={ProxyEnvironment.CLIENT})
public class LBRClientProxy
extends LBRProxy {
    private Microchip.Immutable watchedMicrochip;
    private StickyNoteView watchedStickyNote;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleUpdateMicrochip(int containerId, Microchip microchip) {
        AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
        if (abstractContainerMenu instanceof MicrochipMenu) {
            MicrochipMenu menu = (MicrochipMenu)abstractContainerMenu;
            if (menu.containerId == containerId) {
                menu.microchip().loadFrom(microchip);
                Screen screen = Minecraft.getInstance().screen;
                if (!(screen instanceof MicrochipScreen)) return;
                MicrochipScreen screen2 = (MicrochipScreen)screen;
                screen2.handleUpdate();
                return;
            }
        }
        LBR.LOGGER.warn("Received UpdateMicrochipPacket while not in a microchip screen, discarding");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public void handleUpdateComponentsMicrochip(int containerId, List<LogicEntry> entries) {
        MicrochipMenu menu;
        Object object;
        block4: {
            block3: {
                object = Minecraft.getInstance().player.containerMenu;
                if (!(object instanceof MicrochipMenu)) break block3;
                menu = (MicrochipMenu)((Object)object);
                if (menu.containerId == containerId) break block4;
            }
            LBR.LOGGER.warn("Received UpdateComponentsMicrochipPacket while not in a microchip screen, discarding");
            return;
        }
        object = entries.iterator();
        while (object.hasNext()) {
            LogicEntry entry = (LogicEntry)object.next();
            LogicEntry existingEntry = (LogicEntry)menu.microchip().components().get(entry.slot());
            if (existingEntry == null) continue;
            existingEntry.component().loadFrom(entry.component());
        }
    }

    @Override
    public void openStickyNote(StickyNoteReference reference, boolean edit) {
        Minecraft minecraft = Minecraft.getInstance();
        if (edit) {
            minecraft.setScreen((Screen)new StickyNoteEditScreen(reference, false));
        } else {
            minecraft.setScreen((Screen)new StickyNoteViewScreen(reference));
        }
    }

    @Override
    public void floppyDiskGuiOverlayUpdate(boolean force) {
        FloppyDiskConsumeItemsGuiOverlay.update(force);
    }

    @Override
    public void updateWatchedMicrochip(Microchip microchip) {
        this.watchedMicrochip = microchip == null ? null : microchip.immutable();
        FloppyDiskConsumeItemsGuiOverlay.update(true);
    }

    @Override
    public Microchip.Immutable getWatchedMicrochip() {
        return this.watchedMicrochip;
    }

    @Override
    public void updateWatchedStickyNote(StickyNoteView stickyNote) {
        this.watchedStickyNote = stickyNote;
        StickyNoteViewContentsGuiOverlay.update(this.watchedStickyNote);
    }

    @Override
    public StickyNoteView getWatchedStickyNote() {
        return this.watchedStickyNote;
    }

    @Override
    public void openFloppyDisk(InteractionHand hand) {
        Minecraft.getInstance().setScreen((Screen)new FloppyDiskScreen(hand));
    }

    @Override
    public void setPickedItem(ItemStack stack) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        Inventory inventory = player.getInventory();
        inventory.setPickedItem(stack);
        minecraft.gameMode.handleCreativeModeItemAdd(player.getItemInHand(InteractionHand.MAIN_HAND), 36 + inventory.selected);
    }
}

