/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.gui.logicconfig.LogicConfigMenu;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.microchip.MicrochipViewPosition;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record OpenLogicConfigPacket(int containerId, int slot, MicrochipViewPosition returnViewPosition) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, OpenLogicConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, OpenLogicConfigPacket::containerId, (StreamCodec)ByteBufCodecs.VAR_INT, OpenLogicConfigPacket::slot, MicrochipViewPosition.STREAM_CODEC, OpenLogicConfigPacket::returnViewPosition, OpenLogicConfigPacket::new);

    /*
     * Enabled aggressive block sorting
     */
    public void handle(PacketContext context) {
        AbstractContainerMenu abstractContainerMenu;
        context.assertServerbound();
        Player player = context.getPlayer();
        String playerName = player.getGameProfile().getName();
        if (player.hasContainerOpen() && (abstractContainerMenu = player.containerMenu) instanceof MicrochipMenu) {
            final MicrochipMenu menu = (MicrochipMenu)abstractContainerMenu;
            if (menu.containerId == this.containerId) {
                BlockPos pos = menu.blockPos();
                BlockEntity blockEntity = player.level().getBlockEntity(pos);
                if (!(blockEntity instanceof MicrochipBlockEntity)) {
                    LBR.LOGGER.warn("Received OpenLogicConfigPacket from {} for non-existent block entity?, discarding", (Object)playerName);
                    return;
                }
                final Microchip microchip = menu.microchip();
                final LogicEntry entry = (LogicEntry)microchip.components().get(this.slot);
                if (entry != null && ((LogicConfig)entry.component().config()).hasMenu()) {
                    player.openMenu(new MenuProvider(){

                        public Component getDisplayName() {
                            return entry.component().type().displayName();
                        }

                        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                            return new LogicConfigMenu(containerId, playerInventory, menu.blockPos(), () -> menu.stillValid(player) && microchip.components().values().contains(entry), entry.color().orElse(menu.color()), entry, OpenLogicConfigPacket.this.returnViewPosition);
                        }
                    }, buf -> {
                        buf.writeBlockPos(menu.blockPos());
                        DyeColor.STREAM_CODEC.encode(buf, (Object)entry.color().orElse(menu.color()));
                        LogicEntry.STREAM_CODEC.encode(buf, (Object)entry);
                        MicrochipViewPosition.STREAM_CODEC.encode(buf, (Object)this.returnViewPosition);
                    });
                    return;
                }
                LBR.LOGGER.warn("Received OpenLogicConfigPacket from {} targetting mismatching or non-existent component or a component with no config menu (slot {})", (Object)playerName, (Object)this.slot);
                return;
            }
        }
        LBR.LOGGER.warn("Received OpenLogicConfigPacket from {} while not in a microchip menu (or in expired one?), discarding", (Object)playerName);
    }
}

