/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.randomizer;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.randomizer.LogicRandomizerConfig;

public final class LogicRandomizer
extends LogicComponent<LogicRandomizer, LogicRandomizerConfig> {
    private static final RandomSource RANDOM = RandomSource.create();
    public static final MapCodec<LogicRandomizer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LogicRandomizerConfig.CODEC.fieldOf("config").forGetter(LogicComponent::config), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.intRange((int)-1, (int)9).optionalFieldOf("outputIndex", (Object)-1).forGetter(LogicRandomizer::outputIndex)).apply((Applicative)instance, LogicRandomizer::new));
    public static final StreamCodec<ByteBuf, LogicRandomizer> STREAM_CODEC = StreamCodec.composite(LogicRandomizerConfig.STREAM_CODEC, LogicComponent::config, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.INT, LogicRandomizer::outputIndex, LogicRandomizer::new);
    private int outputIndex;

    private LogicRandomizer(LogicRandomizerConfig config, Optional<DyeColor> color, int outputIndex) {
        super(config, color);
        this.outputIndex = outputIndex;
    }

    private LogicRandomizer(Optional<DyeColor> color, int outputIndex) {
        super(color);
        this.outputIndex = outputIndex;
    }

    public LogicRandomizer() {
        this(Optional.empty(), -1);
    }

    public int outputIndex() {
        return this.outputIndex;
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        int originalOutputIndex = this.outputIndex;
        this.outputIndex = inputs[0] && RANDOM.nextFloat() <= ((LogicRandomizerConfig)this.config).chance ? RANDOM.nextInt(((LogicRandomizerConfig)this.config).outputs) : -1;
        if (originalOutputIndex != this.outputIndex) {
            context.markDirty(this);
        }
    }

    @Override
    protected boolean outputInternal(int index) {
        return index == this.outputIndex;
    }

    @Override
    public LogicGridSize size() {
        int outputs = this.outputs();
        return new LogicGridSize(1, Math.max(1, outputs / 2));
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicHelpRandomizer());
    }

    @Override
    protected void internalLoadFrom(LogicRandomizer other) {
        this.outputIndex = other.outputIndex;
    }

    @Override
    protected void internalResetForPickup() {
        this.outputIndex = -1;
    }

    @Override
    protected LogicRandomizerConfig defaultConfig() {
        return new LogicRandomizerConfig();
    }

    @Override
    public LogicType<LogicRandomizer> type() {
        return LogicTypes.RANDOMIZER;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type(), this.config, this.color, this.outputIndex});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicRandomizer)) return false;
        LogicRandomizer other = (LogicRandomizer)o;
        if (!Objects.equal((Object)this.config, (Object)other.config)) return false;
        if (!Objects.equal((Object)this.color, (Object)other.color)) return false;
        if (this.outputIndex != other.outputIndex) return false;
        return true;
    }
}

