/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.microchip.MicrochipSize;
import net.swedz.little_big_redstone.microchip.awareness.MicrochipAwarenesses;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.MicrochipObjectContainer;
import net.swedz.little_big_redstone.microchip.object.MicrochipObjectContainerType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponents;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.note.MicrochipStickyNotes;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;
import net.swedz.little_big_redstone.microchip.wire.MicrochipWires;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.tesseract.neoforge.api.Bounds;

public final class Microchip {
    public static final Codec<Microchip> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MicrochipSize.CODEC.fieldOf("size").forGetter(Microchip::size), (App)MicrochipStickyNotes.CODEC.optionalFieldOf("sticky_notes").forGetter(m -> Optional.of(m.stickyNotes())), (App)LogicComponents.CODEC.optionalFieldOf("components").forGetter(m -> Optional.of(m.components())), (App)MicrochipWires.CODEC.optionalFieldOf("wires").forGetter(m -> Optional.of(m.wires()))).apply((Applicative)instance, (size, notes, components, wires) -> new Microchip((MicrochipSize)size, notes.orElse(null), components.orElse(null), wires.orElse(null))));
    public static final StreamCodec<ByteBuf, Microchip> STREAM_CODEC = StreamCodec.composite(MicrochipSize.STREAM_CODEC, Microchip::size, MicrochipStickyNotes.STREAM_CODEC, Microchip::stickyNotes, LogicComponents.STREAM_CODEC, Microchip::components, MicrochipWires.STREAM_CODEC, Microchip::wires, Microchip::new);
    private final MicrochipSize size;
    private final MicrochipStickyNotes stickyNotes;
    private final LogicComponents components;
    private final MicrochipWires wires;
    private final MicrochipAwarenesses awarenesses;
    private boolean dirty;

    private Microchip(MicrochipSize size, MicrochipStickyNotes stickyNotes, LogicComponents components, MicrochipWires wires) {
        this.size = size;
        this.stickyNotes = stickyNotes != null ? stickyNotes.with(this) : new MicrochipStickyNotes(this);
        this.components = components != null ? components.with(this) : new LogicComponents(this);
        this.components.updateValidity();
        this.wires = wires != null ? wires.with(this) : new MicrochipWires(this);
        this.components.rebuildTraversal();
        this.awarenesses = new MicrochipAwarenesses();
        this.awarenesses.rebuild(this);
        this.awarenesses.load(this);
        Microchip.removeDanglingWires(this.wires, this.components);
    }

    public Microchip(MicrochipSize size) {
        this.size = size;
        this.stickyNotes = new MicrochipStickyNotes(this);
        this.components = new LogicComponents(this);
        this.components.updateValidity();
        this.wires = new MicrochipWires(this);
        this.components.rebuildTraversal();
        this.awarenesses = new MicrochipAwarenesses();
        this.awarenesses.rebuild(this);
    }

    public MicrochipSize size() {
        return this.size;
    }

    public MicrochipStickyNotes stickyNotes() {
        return this.stickyNotes;
    }

    public LogicComponents components() {
        return this.components;
    }

    public boolean isDebug() {
        return this.components.isDebug();
    }

    public MicrochipWires wires() {
        return this.wires;
    }

    public MicrochipAwarenesses awarenesses() {
        return this.awarenesses;
    }

    private List<MicrochipObjectContainer<?, ?>> objectContainers() {
        return List.of(this.stickyNotes, this.components);
    }

    public Iterable<MicrochipObject> objects() {
        return Iterables.concat(this.objectContainers());
    }

    private MicrochipObjectContainer<?, ?> getContainer(MicrochipObjectContainerType containerType) {
        return switch (containerType) {
            default -> throw new MatchException(null, null);
            case MicrochipObjectContainerType.STICKY_NOTE -> this.stickyNotes;
            case MicrochipObjectContainerType.LOGIC_COMPONENT -> this.components;
        };
    }

    public MicrochipObject get(int slot, MicrochipObjectContainerType containerType) {
        return this.getContainer(containerType).get(slot);
    }

    public boolean canFit(Bounds bounds) {
        for (MicrochipObjectContainer<?, ?> container : this.objectContainers()) {
            if (container.canFit(bounds)) continue;
            return false;
        }
        return true;
    }

    public boolean canFit(int x, int y, LogicComponent component) {
        return this.canFit(component.size().toBounds(x, y));
    }

    public MicrochipObject findAt(int x, int y) {
        for (MicrochipObjectContainer<?, ?> container : this.objectContainers()) {
            Object found = container.findAt(x, y);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public MicrochipObject findAt(int x, int y, MicrochipObjectContainerType containerType) {
        return this.getContainer(containerType).findAt(x, y);
    }

    public void loadFrom(Microchip other) {
        this.stickyNotes.loadFrom(other.stickyNotes());
        this.components.loadFrom(other.components());
        this.wires.loadFrom(other.wires());
        this.markDirty();
    }

    public void loadFrom(Immutable other) {
        this.stickyNotes.loadFrom(other.stickyNotes);
        this.components.loadFrom(other.components);
        this.wires.loadFrom(other.wires);
        this.markDirty();
    }

    public Immutable immutable() {
        return new Immutable(this);
    }

    public void clear() {
        this.stickyNotes.clear();
        this.components.clear();
        this.wires.clear();
        this.markDirty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.components.rebuildTraversal();
        this.awarenesses.rebuild(this);
        this.awarenesses.load(this);
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void tickLogic(LogicContext context) {
        for (LogicEntry entry : this.components.traversal()) {
            int inputSlot = entry.slot();
            int totalInputs = entry.component().inputs();
            boolean[] inputs = new boolean[totalInputs];
            block1: for (int inputPort = 0; inputPort < totalInputs; ++inputPort) {
                for (Wire wire : this.wires.getByInputSlot(inputSlot)) {
                    if (wire.input().index() != inputPort || !((LogicEntry)this.components.get(wire.output().slot())).component().output(wire.output().index())) continue;
                    inputs[inputPort] = true;
                    continue block1;
                }
            }
            entry.component().processTick(context, inputs);
        }
    }

    public int hashCode() {
        return Objects.hash(this.stickyNotes, this.components, this.wires);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Immutable)) return false;
        Immutable other = (Immutable)o;
        if (!this.stickyNotes.equals(other.stickyNotes)) return false;
        if (!this.components.equals(other.components)) return false;
        if (!this.wires.equals(other.wires)) return false;
        return true;
    }

    private static boolean removeDanglingWires(MicrochipWires wires, LogicComponents components) {
        boolean removed = false;
        for (Wire wire : Lists.newArrayList((Iterable)wires)) {
            if (components.has(wire.output().slot()) && components.has(wire.input().slot())) continue;
            wires.remove(wire);
            removed = true;
        }
        return removed;
    }

    public static final class Immutable {
        public static final Codec<Immutable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MicrochipStickyNotes.CODEC.optionalFieldOf("sticky_notes").forGetter(m -> Optional.of(m.stickyNotes)), (App)LogicComponents.CODEC.optionalFieldOf("components").forGetter(m -> Optional.of(m.components)), (App)MicrochipWires.CODEC.optionalFieldOf("wires").forGetter(m -> Optional.of(m.wires))).apply((Applicative)instance, (notes, components, wires) -> new Immutable(notes.orElse(null), components.orElse(null), wires.orElse(null))));
        public static final StreamCodec<ByteBuf, Immutable> STREAM_CODEC = StreamCodec.composite(MicrochipStickyNotes.STREAM_CODEC, m -> m.stickyNotes, LogicComponents.STREAM_CODEC, m -> m.components, MicrochipWires.STREAM_CODEC, m -> m.wires, Immutable::new);
        private final MicrochipStickyNotes stickyNotes;
        private final LogicComponents components;
        private final MicrochipWires wires;

        private Immutable(MicrochipStickyNotes stickyNotes, LogicComponents components, MicrochipWires wires) {
            this.stickyNotes = stickyNotes != null ? stickyNotes : new MicrochipStickyNotes(null);
            this.components = components != null ? components : new LogicComponents(null);
            this.wires = wires != null ? wires : new MicrochipWires(null);
            Microchip.removeDanglingWires(this.wires, this.components);
        }

        private Immutable(Microchip microchip) {
            Microchip copy = new Microchip(microchip.size());
            this.stickyNotes = new MicrochipStickyNotes(copy);
            this.stickyNotes.loadFrom(microchip.stickyNotes);
            this.components = new LogicComponents(copy);
            this.components.loadFrom(microchip.components);
            this.wires = new MicrochipWires(copy);
            this.wires.loadFrom(microchip.wires);
        }

        public Iterable<StickyNoteEntry> stickyNotes() {
            return this.stickyNotes;
        }

        public Iterable<LogicEntry> components() {
            return this.components;
        }

        public int wireCount() {
            return this.wires.values().size();
        }

        public int hashCode() {
            return Objects.hash(this.stickyNotes, this.components, this.wires);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Immutable)) return false;
            Immutable other = (Immutable)o;
            if (!this.stickyNotes.equals(other.stickyNotes)) return false;
            if (!this.components.equals(other.components)) return false;
            if (!this.wires.equals(other.wires)) return false;
            return true;
        }
    }
}

