/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.microchip.element;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import java.util.Set;
import net.swedz.little_big_redstone.guide.tags.microchip.MicrochipGuidebookScene;
import net.swedz.little_big_redstone.guide.tags.microchip.element.MicrochipSceneElementTagCompiler;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;

public final class WireElementTagCompiler
implements MicrochipSceneElementTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("Wire");
    }

    @Override
    public void compile(MicrochipGuidebookScene microchip, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        String from = MdxAttrs.getString((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"from", null);
        if (from == null) {
            errorSink.appendError(compiler, "Missing 'from' attribute", (UnistNode)el);
            return;
        }
        String to = MdxAttrs.getString((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"to", null);
        if (to == null) {
            errorSink.appendError(compiler, "Missing 'to' attribute", (UnistNode)el);
            return;
        }
        int fromPort = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"fromPort", (int)0);
        int toPort = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"toPort", (int)0);
        Boolean powerLock = el.getAttribute("powered") == null ? null : Boolean.valueOf(MdxAttrs.getBoolean((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"powered", (boolean)false));
        microchip.addWire(from, to, fromPort, toPort, compiler, errorSink, el);
        if (powerLock != null) {
            LogicEntry fromLogic = microchip.getLogic(from);
            ((LogicConfig)fromLogic.component().config()).setOutputLock(fromPort, powerLock);
        }
    }

    @Override
    public boolean isDelayed() {
        return true;
    }
}

